/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.darkhax.bookshelf.lib.ModTrackingList;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class CraftingUtils {
    private CraftingUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static IRecipe getRecipeForMatrix(InventoryCrafting craftInv, World world) {
        for (IRecipe recipe : CraftingManager.func_77594_a().field_77597_b) {
            if (!recipe.func_77569_a(craftInv, world)) continue;
            return recipe;
        }
        return null;
    }

    public static IRecipe getCurrentCraftingRecipe(EntityPlayer player) {
        ContainerWorkbench container = CraftingUtils.getCraftingContainer(player);
        return container != null ? CraftingUtils.getRecipeForMatrix(container.field_75162_e, player.func_130014_f_()) : null;
    }

    public static ItemStack getCurrentCraftingOutput(EntityPlayer player) {
        ContainerWorkbench container = CraftingUtils.getCraftingContainer(player);
        return container != null ? container.field_75160_f.func_70301_a(0) : ItemStack.field_190927_a;
    }

    public static ContainerWorkbench getCraftingContainer(EntityPlayer player) {
        Container container = player.field_71070_bA;
        return container instanceof ContainerWorkbench ? (ContainerWorkbench)container : null;
    }

    public static ModContainer getOwner(IRecipe recipe) {
        List recipes = CraftingManager.func_77594_a().field_77597_b;
        if (recipes instanceof ModTrackingList) {
            return ((ModTrackingList)recipes).getModContainer(recipe);
        }
        return null;
    }

    public static Map<IRecipe, ModContainer> getRecipeOwners() {
        List recipes = CraftingManager.func_77594_a().field_77597_b;
        return recipes instanceof ModTrackingList ? ((ModTrackingList)recipes).getTrackedEntries() : Collections.emptyMap();
    }

    public static List<ShapedRecipes> getShapedRecipes(ItemStack stack) {
        return CraftingUtils.getRecipesForStack(stack, recipe -> recipe instanceof ShapedRecipes);
    }

    public static List<ShapedOreRecipe> getShapedOreRecipe(ItemStack stack) {
        return CraftingUtils.getRecipesForStack(stack, recipe -> recipe instanceof ShapedOreRecipe);
    }

    public static List<ShapelessRecipes> getShapelessRecipes(ItemStack stack) {
        return CraftingUtils.getRecipesForStack(stack, recipe -> recipe instanceof ShapelessRecipes);
    }

    public static List<ShapelessOreRecipe> getShapelessOreRecipe(ItemStack stack) {
        return CraftingUtils.getRecipesForStack(stack, recipe -> recipe instanceof ShapelessOreRecipe);
    }

    public static List<IRecipe> getAnyRecipe(ItemStack stack) {
        return CraftingUtils.getRecipesForStack(stack, recipe -> true);
    }

    public static <T extends IRecipe> List<T> getRecipesForStack(ItemStack stack, Predicate<IRecipe> condition) {
        ArrayList<IRecipe> foundRecipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            ItemStack result;
            if (!condition.test(recipe) || !StackUtils.areStacksEqual(result = recipe.func_77571_b(), stack, result.func_77942_o())) continue;
            foundRecipes.add(recipe);
        }
        return foundRecipes;
    }

    public static void createConversionRecipes(ItemStack input, ItemStack output) {
        for (int amount = 1; amount < 10; ++amount) {
            Object[] inputs = new ItemStack[amount];
            Arrays.fill(inputs, input);
            GameRegistry.addShapelessRecipe((ItemStack)StackUtils.copyStackWithSize(output, amount), (Object[])inputs);
        }
    }

    public static Object validateCrafting(Object object) {
        if (object instanceof ItemStack) {
            return !((ItemStack)object).func_190926_b() ? object : Blocks.field_150480_ab;
        }
        return object != null ? object : Blocks.field_150480_ab;
    }
}

