/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.darkhax.bookshelf.lib.Constants;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public final class MathsUtils {
    private MathsUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean isInRange(double min, double max, double value) {
        return value <= max && value >= min;
    }

    public static double getDistanceBetweenPoints(Vec3d firstPos, Vec3d secondPos) {
        double distanceX = firstPos.field_72450_a - secondPos.field_72450_a;
        double distanceY = firstPos.field_72448_b - secondPos.field_72448_b;
        double distanceZ = firstPos.field_72449_c - secondPos.field_72449_c;
        return Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
    }

    public static double round(double value, int places) {
        return value >= 0.0 && places > 0 ? BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).doubleValue() : value;
    }

    public static int nextIntInclusive(int min, int max) {
        return Constants.RANDOM.nextInt(max - min + 1) + min;
    }

    public static RayTraceResult rayTrace(EntityPlayer player, double length) {
        Vec3d vec1 = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d vec2 = player.func_70040_Z();
        Vec3d vec3 = vec1.func_72441_c(vec2.field_72450_a * length, vec2.field_72448_b * length, vec2.field_72449_c * length);
        return player.field_70170_p.func_72933_a(vec1, vec3);
    }

    public static boolean tryPercentage(double percent) {
        return Math.random() < percent;
    }

    public static int getRandomColor() {
        return new Color(Constants.RANDOM.nextFloat(), Constants.RANDOM.nextFloat(), Constants.RANDOM.nextFloat()).getRGB();
    }

    public static int getAverage(int first, int second) {
        return Math.round((float)(first + second) / 2.0f);
    }

    public static String ticksToTime(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        return minutes + ":" + seconds;
    }
}

