/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.Resources;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.baubles.BaubleUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PlayerUtils {
    public static BiMap<String, UUID> PROFILE_CACHE = HashBiMap.create();

    private PlayerUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean canPlayerSleep(EntityPlayer player) {
        return !player.func_70608_bn() && player.func_70089_S() && player.field_70170_p.func_72820_D() > 12541L && player.field_70170_p.func_72820_D() < 23458L;
    }

    public static boolean isPlayerReal(EntityPlayer player) {
        return player != null && player.field_70170_p != null && player.getClass() == EntityPlayerMP.class;
    }

    public static EntityPlayer getPlayerFromUUID(World world, UUID playerID) {
        for (Object playerEntry : world.field_73010_i) {
            EntityPlayer player;
            if (!(playerEntry instanceof EntityPlayer) || !(player = (EntityPlayer)playerEntry).func_110124_au().equals(playerID)) continue;
            return player;
        }
        return null;
    }

    public static String getPlayerNameFromUUID(UUID uuid) {
        if (PROFILE_CACHE.containsValue((Object)uuid)) {
            return (String)PROFILE_CACHE.inverse().get((Object)uuid);
        }
        String name = null;
        try {
            BufferedReader reader = Resources.asCharSource((URL)new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "")), (Charset)StandardCharsets.UTF_8).openBufferedStream();
            JsonReader json = new JsonReader((Reader)reader);
            json.beginObject();
            while (json.hasNext()) {
                if ("name".equals(json.nextName())) {
                    name = json.nextString();
                    continue;
                }
                json.skipValue();
            }
            json.endObject();
            json.close();
            reader.close();
        }
        catch (Exception exception) {
            Constants.LOG.warn("Could not get name for " + uuid, (Throwable)exception);
            name = exception.getMessage();
        }
        return name;
    }

    public static UUID getUUIDFromName(String username) {
        if (PROFILE_CACHE.containsKey((Object)username)) {
            return (UUID)PROFILE_CACHE.get((Object)username);
        }
        UUID uuid = null;
        try {
            BufferedReader reader = Resources.asCharSource((URL)new URL("https://api.mojang.com/users/profiles/minecraft/" + username), (Charset)StandardCharsets.UTF_8).openBufferedStream();
            JsonReader json = new JsonReader((Reader)reader);
            json.beginObject();
            while (json.hasNext()) {
                if ("id".equals(json.nextName())) {
                    uuid = PlayerUtils.fixStrippedUUID(json.nextString());
                    continue;
                }
                json.skipValue();
            }
            json.endObject();
            json.close();
            reader.close();
        }
        catch (Exception exception) {
            Constants.LOG.warn("Could not get name for " + username, (Throwable)exception);
        }
        return uuid;
    }

    public static UUID fixStrippedUUID(String uuidString) {
        return uuidString.length() != 32 ? null : UUID.fromString(uuidString.substring(0, 8) + "-" + uuidString.substring(8, 12) + "-" + uuidString.substring(12, 16) + "-" + uuidString.substring(16, 20) + "-" + uuidString.substring(20, 32));
    }

    public static int getItemCountInInv(EntityPlayer player, Item item) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !stack.func_77973_b().equals(item)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static boolean playerHasItem(EntityPlayer player, Item item, int meta) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !stack.func_77973_b().equals(item) || meta >= 0 && stack.func_77960_j() != meta) continue;
            return true;
        }
        if (Loader.isModLoaded((String)"baubles")) {
            return BaubleUtils.hasItem(player, item, meta);
        }
        return false;
    }

    public static List<ItemStack> getStacksFromPlayer(EntityPlayer player, Item item, int meta) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != item || meta >= 0 && stack.func_77960_j() != meta) continue;
            items.add(stack);
        }
        if (Loader.isModLoaded((String)"baubles")) {
            items.addAll(BaubleUtils.getBaublesFromPlayer(player, item, meta));
        }
        return items;
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendSpamlessMessage(int messageID, ITextComponent message) {
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        chat.func_146234_a(message, messageID);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isPlayerInGame() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g != null && mc.field_71441_e != null && mc.field_71439_g.field_70170_p != null;
    }

    @SideOnly(value=Side.CLIENT)
    public static UUID getClientUUID() {
        return PlayerUtils.fixStrippedUUID(Minecraft.func_71410_x().func_110432_I().func_148255_b());
    }
}

