/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util.baubles;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

public final class BaubleUtils {
    public static final int AMULTER = 0;
    public static final int RING_1 = 1;
    public static final int RING_2 = 2;
    public static final int BELT = 3;
    public static final int HEAD = 4;
    public static final int BODY = 5;
    public static final int CHARM = 6;

    private BaubleUtils() {
        throw new IllegalAccessError("Utility class");
    }

    @Optional.Method(modid="baubles")
    public static boolean hasItem(EntityPlayer player, Item item, int meta) {
        ItemStack stack;
        BaubleType type = BaubleUtils.getBaubleType(item, meta);
        if (type != null && !(stack = BaubleUtils.getBauble(player, type)).func_190926_b()) {
            return stack.func_77973_b().equals(item) && (meta < 0 || stack.func_77960_j() == meta);
        }
        return false;
    }

    @Optional.Method(modid="baubles")
    public static List<ItemStack> getBaublesFromPlayer(EntityPlayer player, Item item, int meta) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int slot = 0; slot < BaubleType.TRINKET.getValidSlots().length; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack == null || stack.func_77973_b() != item || meta >= 0 && stack.func_77960_j() != meta) continue;
            items.add(stack);
        }
        return items;
    }

    @Optional.Method(modid="baubles")
    public static BaubleType getBaubleType(Item item, int meta) {
        if (item instanceof IBauble) {
            return ((IBauble)item).getBaubleType(new ItemStack(item, meta));
        }
        return null;
    }

    @Optional.Method(modid="baubles")
    public static ItemStack getBauble(EntityPlayer player, BaubleType type) {
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int slotId : type.getValidSlots()) {
            ItemStack stack;
            if (inv == null || (stack = inv.getStackInSlot(slotId)) == null) continue;
            return stack;
        }
        return null;
    }

    @Optional.Method(modid="baubles")
    public static ItemStack getBauble(EntityPlayer player, int type) {
        ItemStack stack;
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        if (inv != null && (stack = inv.getStackInSlot(type)) != null) {
            return stack;
        }
        return null;
    }

    @Optional.Method(modid="baubles")
    public static boolean hasBauble(EntityPlayer player, ItemStack stack, BaubleType type) {
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int slotId : type.getValidSlots()) {
            if (inv == null || !StackUtils.areStacksSimilar(stack, inv.getStackInSlot(slotId))) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="baubles")
    public static boolean equipBauble(EntityPlayer player, ItemStack item, int slot) {
        ItemStack existing;
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        if (inv != null && (existing = inv.getStackInSlot(slot)) == null) {
            inv.setStackInSlot(slot, item.func_77946_l());
            item.func_190918_g(1);
            return true;
        }
        return false;
    }
}

