/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client.model;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.model.ModelBiped;
import net.minecraft.client.renderer.entity.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ModelArmorExtended
extends ModelBiped {
    public abstract void addModelParts();

    private void syncModel(Entity entity, float partialTicks) {
        EntityLivingBase living = (EntityLivingBase)entity;
        if (living != null) {
            this.field_78117_n = living.func_70093_af();
            this.field_78091_s = living.func_70631_g_();
            if (living instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)living;
                ModelBiped.ArmPose poseMainhand = this.getArmPose(player.func_184614_ca(), player);
                ModelBiped.ArmPose poseOffhand = this.getArmPose(player.func_184592_cb(), player);
                boolean isRightHanded = player.func_184591_cq() == EnumHandSide.RIGHT;
                this.field_187076_m = isRightHanded ? poseMainhand : poseOffhand;
                this.field_187075_l = isRightHanded ? poseOffhand : poseMainhand;
                this.field_78095_p = player.func_70678_g(partialTicks);
            }
        }
    }

    public void setRotateAngle(ModelRenderer render, float x, float y, float z) {
        render.field_78795_f = x;
        render.field_78796_g = y;
        render.field_78808_h = z;
    }

    private ModelBiped.ArmPose getArmPose(ItemStack stack, EntityPlayer player) {
        if (stack.func_190926_b()) {
            return ModelBiped.ArmPose.EMPTY;
        }
        ModelBiped.ArmPose pose = ModelBiped.ArmPose.ITEM;
        if (player.func_184605_cv() > 0) {
            EnumAction action = stack.func_77975_n();
            pose = action == EnumAction.BLOCK ? ModelBiped.ArmPose.BLOCK : (action == EnumAction.BOW ? ModelBiped.ArmPose.BOW_AND_ARROW : pose);
        }
        return pose;
    }

    public void func_78088_a(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTicks) {
        this.addModelParts();
        GlStateManager.func_179094_E();
        if (entity instanceof EntityArmorStand) {
            netHeadYaw = 0.0f;
            GlStateManager.func_179109_b((float)0.0f, (float)0.15f, (float)0.0f);
        }
        this.syncModel(entity, partialTicks);
        super.func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, partialTicks);
        GlStateManager.func_179121_F();
    }
}

