/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.chunk.RenderChunk;

public class PerformanceInfo {
    private final int fps = Minecraft.func_175610_ah();
    private final int chunkUpdates = RenderChunk.field_178592_a;
    private final long maxMemory;
    private final long totalMemory;
    private final long freeMemory;
    private final long usedMemory;

    public PerformanceInfo() {
        Runtime runtime = Runtime.getRuntime();
        this.maxMemory = runtime.maxMemory();
        this.totalMemory = runtime.totalMemory();
        this.freeMemory = runtime.freeMemory();
        this.usedMemory = this.totalMemory - this.freeMemory;
    }

    public int getFps() {
        return this.fps;
    }

    public int getChunkUpdates() {
        return this.chunkUpdates;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getMaxMemoryMb() {
        return PerformanceInfo.bytesToMb(this.maxMemory);
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getTotalMemoryMb() {
        return PerformanceInfo.bytesToMb(this.totalMemory);
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getFreeMemoryMb() {
        return PerformanceInfo.bytesToMb(this.totalMemory);
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getUsedMemoryMb() {
        return PerformanceInfo.bytesToMb(this.usedMemory);
    }

    public String getMemoryString() {
        return String.format("Mem:% 2d%% %03d/%03dMB", this.getUsedMemory() * 100L / this.getMaxMemory(), this.getUsedMemoryMb(), this.getMaxMemoryMb());
    }

    public String getAllocatedString() {
        return String.format("Allocated:% 2d%% %03dMB", this.getUsedMemory() * 100L / this.getMaxMemory(), this.getUsedMemoryMb());
    }

    public static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }
}

