/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

public class RegistryHelper {
    private final String modid;
    private final Logger logger;
    private final ItemGroup group;
    private final List<Block> blocks = NonNullList.func_191196_a();
    private final List<Item> items = NonNullList.func_191196_a();
    private final List<TileEntityType<?>> tileEntityTypes = NonNullList.func_191196_a();

    public RegistryHelper(String modid, Logger logger, ItemGroup group) {
        this.modid = modid;
        this.logger = logger;
        this.group = group;
    }

    public void initialize(IEventBus modBus) {
        modBus.addGenericListener(Block.class, this::registerBlocks);
        modBus.addGenericListener(Item.class, this::registerItems);
    }

    private void registerBlocks(RegistryEvent.Register<Block> event) {
        if (!this.blocks.isEmpty()) {
            this.logger.info("Registering {} blocks.", (Object)this.blocks.size());
            IForgeRegistry registry = event.getRegistry();
            for (Block block : this.blocks) {
                registry.register((IForgeRegistryEntry)block);
            }
        }
    }

    public Block registerBlock(Block block, String id) {
        return this.registerBlock(block, new ItemBlock(block, new Item.Properties().func_200916_a(this.group)), id);
    }

    public Block registerBlock(Block block, ItemBlock item, String id) {
        block.setRegistryName(new ResourceLocation(this.modid, id));
        this.blocks.add(block);
        this.registerItem((Item)item, id);
        return block;
    }

    private void registerItems(RegistryEvent.Register<Item> event) {
        if (!this.items.isEmpty()) {
            this.logger.info("Registering {} items.", (Object)this.items.size());
            IForgeRegistry registry = event.getRegistry();
            for (Item item : this.items) {
                registry.register((IForgeRegistryEntry)item);
            }
        }
    }

    public void registerItem(Item item, String id) {
        item.setRegistryName(new ResourceLocation(this.modid, id));
        this.items.add(item);
    }

    public TileEntityType<?> registerTileEntity(Supplier<? extends TileEntity> factory, String id) {
        ResourceLocation fullId = new ResourceLocation(this.modid, id);
        TileEntityType type = TileEntityType.func_200966_a((String)fullId.toString(), (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(factory));
        this.tileEntityTypes.add(type);
        return type;
    }
}

