/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class PlayerUtils {
    public static final String BIRTHDAY_BOY_UUID = "10755ea6-9721-467a-8b5c-92adf689072c";

    public static boolean canPlayerSleep(EntityPlayer player) {
        return !player.func_70608_bn() && player.func_70089_S() && player.field_70170_p.func_72820_D() > 12541L && player.field_70170_p.func_72820_D() < 23458L;
    }

    public static boolean isPlayerReal(Entity player) {
        return player != null && player.field_70170_p != null && player.getClass() == EntityPlayerMP.class;
    }

    public static EntityPlayer getPlayerFromUUID(World world, UUID playerID) {
        for (EntityPlayer player : world.field_73010_i) {
            if (player == null || !player.func_110124_au().equals(playerID)) continue;
            return player;
        }
        return null;
    }

    public static UUID fixStrippedUUID(String uuidString) {
        return uuidString.length() != 32 ? null : UUID.fromString(uuidString.substring(0, 8) + "-" + uuidString.substring(8, 12) + "-" + uuidString.substring(12, 16) + "-" + uuidString.substring(16, 20) + "-" + uuidString.substring(20, 32));
    }

    public static int getItemCountInInv(EntityPlayer player, Item item) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !stack.func_77973_b().equals(item)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static boolean playerHasItem(EntityPlayer player, Item item) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !stack.func_77973_b().equals(item)) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getStacksFromPlayer(EntityPlayer player, Item item) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != item) continue;
            items.add(stack);
        }
        return items;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static EntityPlayerSP getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isPlayerInGame() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g != null && mc.field_71441_e != null && mc.field_71439_g.field_70170_p != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static UUID getClientUUID() {
        return PlayerUtils.fixStrippedUUID(Minecraft.func_71410_x().func_110432_I().func_148255_b());
    }

    public static boolean isPlayersBirthdate(EntityPlayer player) {
        return player.func_110124_au().toString().equalsIgnoreCase(BIRTHDAY_BOY_UUID);
    }

    public static boolean isPlayerDamage(DamageSource source) {
        return source != null && source.func_76346_g() instanceof EntityPlayer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation getPlayerTexture(GameProfile profile) {
        if (profile != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map = minecraft.func_152342_ad().func_152788_a(profile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                return minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            }
            return DefaultPlayerSkin.func_177334_a((UUID)EntityPlayer.func_146094_a((GameProfile)profile));
        }
        return DefaultPlayerSkin.func_177335_a();
    }
}

