/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import com.google.common.collect.ImmutableMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.vecmath.Matrix4f;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.ThreadDownloadImageData;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.model.TRSRTransformation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class RenderUtils {
    public static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    private RenderUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static void registerPlayerLayer(LayerRenderer<EntityLivingBase> layer) {
        RenderUtils.getSteveRenderer().func_177094_a(layer);
        RenderUtils.getAlexRenderer().func_177094_a(layer);
    }

    public static RenderPlayer getSteveRenderer() {
        return RenderUtils.getPlayerRenderer("default");
    }

    public static RenderPlayer getAlexRenderer() {
        return RenderUtils.getPlayerRenderer("slim");
    }

    public static RenderPlayer getPlayerRenderer(String type) {
        return (RenderPlayer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get(type);
    }

    public static ResourceLocation downloadResourceLocation(String url, ResourceLocation outputResource, ResourceLocation defaultResource, IImageBuffer buffer) {
        RenderUtils.downloadResource(url, outputResource, defaultResource, buffer);
        return outputResource;
    }

    public static ThreadDownloadImageData downloadResource(String url, ResourceLocation outputResource, ResourceLocation defaultResource, IImageBuffer buffer) {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        ThreadDownloadImageData imageData = (ThreadDownloadImageData)manager.func_110581_b(outputResource);
        if (imageData == null) {
            imageData = new ThreadDownloadImageData(null, url, defaultResource, buffer);
            manager.func_110579_a(outputResource, (ITextureObject)imageData);
        }
        return imageData;
    }

    public static Frustum getCamera(Entity entity, float partialTicks) {
        double cameraX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double cameraY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
        double cameraZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        Frustum camera = new Frustum();
        camera.func_78547_a(cameraX, cameraY, cameraZ);
        return camera;
    }

    public static void translateAgainstPlayer(BlockPos pos, boolean offset) {
        float x = (float)((double)pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b);
        float y = (float)((double)pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c);
        float z = (float)((double)pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d);
        if (offset) {
            GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 0.5f), (float)(z + 0.5f));
        } else {
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        }
    }

    public static TextureAtlasSprite getParticleTexture(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack).func_177554_e();
    }

    public static IBakedModel getBakedModel(ModelResourceLocation name) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(name);
    }

    public static IBakedModel getBakedModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    public static List<BakedQuad> getMissingquads(IBlockState state, EnumFacing side, Random rand) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a().func_200117_a(state, side, rand);
    }

    public static TextureAtlasSprite getSprite(IBlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getBasicTransforms(IBakedModel model) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TRSRTransformation transformation = new TRSRTransformation((Matrix4f)model.handlePerspective(type).getRight());
            if (transformation.equals((Object)TRSRTransformation.identity())) continue;
            builder.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)transformation));
        }
        return builder.build();
    }

    public static IBakedModel getModelForState(IBlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
    }

    public static void saveTextureToFile(int textureId, File file) {
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int size = width * height;
        BufferedImage bufferedimage = new BufferedImage(width, height, 2);
        IntBuffer buffer = BufferUtils.createIntBuffer((int)size);
        int[] data = new int[size];
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)buffer);
        buffer.get(data);
        bufferedimage.setRGB(0, 0, width, height, data, 0, width);
        try {
            ImageIO.write((RenderedImage)bufferedimage, "png", file);
        }
        catch (Exception e) {
            Bookshelf.LOG.error("Failed to save texture {} to {}.", (Object)textureId, (Object)file.getName());
            Bookshelf.LOG.catching((Throwable)e);
        }
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> copyTransforms(IBakedModel model) {
        ImmutableMap.Builder copiedTransforms = ImmutableMap.builder();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TRSRTransformation transformation = new TRSRTransformation((Matrix4f)model.handlePerspective(type).getRight());
            if (transformation.equals((Object)TRSRTransformation.identity())) continue;
            copiedTransforms.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)transformation));
        }
        return copiedTransforms.build();
    }
}

