/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class StackUtils {
    public static NBTTagCompound prepareStackTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static ItemStack prepareStack(ItemStack stack) {
        StackUtils.prepareStackTag(stack);
        return stack;
    }

    public static ItemStack setLore(ItemStack stack, String ... lore) {
        NBTTagList loreList = new NBTTagList();
        for (String line : lore) {
            loreList.add((INBTBase)new NBTTagString(line));
        }
        return StackUtils.setLoreTag(stack, loreList);
    }

    public static ItemStack appendLore(ItemStack stack, String ... lore) {
        NBTTagList loreTag = StackUtils.getLoreTag(stack);
        for (String line : lore) {
            loreTag.add((INBTBase)new NBTTagString(line));
        }
        return stack;
    }

    public static ItemStack setLoreTag(ItemStack stack, NBTTagList lore) {
        NBTTagCompound displayTag = StackUtils.getDisplayTag(stack);
        displayTag.func_74782_a("Lore", (INBTBase)lore);
        return stack;
    }

    public static NBTTagCompound getDisplayTag(ItemStack stack) {
        StackUtils.prepareStackTag(stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_186855_b("display")) {
            tag.func_74782_a("display", (INBTBase)new NBTTagCompound());
        }
        return tag.func_74775_l("display");
    }

    public static NBTTagList getLoreTag(ItemStack stack) {
        NBTTagCompound displayTag = StackUtils.getDisplayTag(stack);
        if (!displayTag.func_186855_b("Lore")) {
            displayTag.func_74782_a("Lore", (INBTBase)new NBTTagList());
        }
        return displayTag.func_150295_c("Lore", 8);
    }

    public static void writeStackToTag(ItemStack stack, NBTTagCompound tag, String tagName) {
        NBTTagCompound stackTag = new NBTTagCompound();
        stack.func_77955_b(stackTag);
        tag.func_74782_a(tagName, (INBTBase)stackTag);
    }

    public static void dropStackInWorld(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float offset = 0.7f;
            double offX = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double offY = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double offZ = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + offX, (double)pos.func_177956_o() + offY, (double)pos.func_177952_p() + offZ, stack);
            entityitem.func_174867_a(10);
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static String getStackIdentifier(ItemStack stack) {
        return stack != null && !stack.func_190926_b() ? stack.func_77973_b().getRegistryName().toString() : "minecraft:air";
    }

    public static NBTTagCompound getTagCleanly(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
    }
}

