/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public final class WorldUtils {
    public static int getLoadedChunks(WorldServer world) {
        return world.func_72863_F() != null ? world.func_72863_F().func_73152_e() : -1;
    }

    public static boolean areSameChunk(BlockPos first, BlockPos second) {
        return new ChunkPos(first).equals((Object)new ChunkPos(second));
    }

    public static void setBiomes(World world, BlockPos pos, Biome biome) {
        try {
            Chunk chunk = world.func_175726_f(pos);
            Object[] biomes = chunk.func_201590_e();
            Arrays.fill(biomes, biome);
            chunk.func_76630_e();
            WorldUtils.updateNearbyChunks(world, chunk, true, true);
        }
        catch (Exception e) {
            Bookshelf.LOG.catching((Throwable)e);
            Bookshelf.LOG.warn("Unable to set biome for Pos: {}, Biome: {}", (Object)pos.toString(), (Object)biome.getRegistryName());
        }
    }

    public static void markChunkForUpdate(World world, Chunk chunk, boolean render) {
        chunk.func_76630_e();
        if (render) {
            BlockPos initial = chunk.func_76632_l().func_180331_a(1, 1, 1);
            world.func_175704_b(initial, initial);
        }
    }

    public static void updateNearbyChunks(World world, Chunk chunk, boolean includeSelf, boolean render) {
        for (Chunk other : WorldUtils.getNearbyChunks(world, chunk)) {
            if (other == chunk && !includeSelf) continue;
            WorldUtils.markChunkForUpdate(world, other, render);
        }
    }

    public static List<Chunk> getNearbyChunks(World world, Chunk chunk) {
        return WorldUtils.getNearbyChunks(world, chunk.func_76632_l());
    }

    public static List<Chunk> getNearbyChunks(World world, ChunkPos chunk) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (int offX = -1; offX < 2; ++offX) {
            for (int offY = -1; offY < 2; ++offY) {
                chunks.add(world.func_72964_e(chunk.field_77276_a + offX, chunk.field_77275_b + offY));
            }
        }
        return chunks;
    }
}

