/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.Logger;

public class CommandRegistry {
    private final Logger logger;
    private final List<LiteralArgumentBuilder<CommandSource>> commands;
    private final Map<String, Tuple<Class, IArgumentSerializer>> commandArguments;

    public CommandRegistry(Logger logger) {
        this.logger = logger;
        this.commands = NonNullList.func_191196_a();
        this.commandArguments = new HashMap<String, Tuple<Class, IArgumentSerializer>>();
    }

    public void initialize(IEventBus bus) {
        if (!this.commands.isEmpty()) {
            MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        }
        if (!this.commandArguments.isEmpty()) {
            bus.addListener(this::registerCommandArguments);
        }
    }

    public LiteralArgumentBuilder<CommandSource> registerCommand(LiteralArgumentBuilder<CommandSource> command) {
        this.commands.add(command);
        return command;
    }

    private void registerCommands(RegisterCommandsEvent event) {
        if (!this.commands.isEmpty()) {
            this.logger.info("Registering {} commands.", (Object)this.commands.size());
            CommandDispatcher dispatcher = event.getDispatcher();
            for (LiteralArgumentBuilder<CommandSource> command : this.commands) {
                dispatcher.register(command);
            }
        }
    }

    public List<LiteralArgumentBuilder<CommandSource>> getCommands() {
        return ImmutableList.copyOf(this.commands);
    }

    public <T extends ArgumentType<?>> void registerCommandArgument(String name, Class<T> clazz, IArgumentSerializer<T> serializer) {
        this.commandArguments.put(name, (Tuple<Class, IArgumentSerializer>)new Tuple(clazz, serializer));
    }

    private void registerCommandArguments(FMLCommonSetupEvent event) {
        this.logger.info("Registering {} command argument types.", (Object)this.commandArguments.size());
        for (Map.Entry<String, Tuple<Class, IArgumentSerializer>> entry : this.commandArguments.entrySet()) {
            ArgumentTypes.func_218136_a((String)entry.getKey(), (Class)((Class)entry.getValue().func_76341_a()), (IArgumentSerializer)((IArgumentSerializer)entry.getValue().func_76340_b()));
        }
    }
}

