/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

public class ForgeRegistryHelper<T extends IForgeRegistryEntry<T>> {
    private final Logger logger;
    private final String ownerId;
    private final Class<T> type;
    private final NonNullList<Supplier<T>> valueSuppliers;
    private final NonNullList<T> values;
    private final List<BiConsumer<ForgeRegistryHelper<T>, T>> registerListeners;
    private final List<BiConsumer<ForgeRegistryHelper<T>, IForgeRegistry<T>>> registryListeners;
    private boolean initialized = false;
    private boolean registered = false;

    public ForgeRegistryHelper(Logger logger, String ownerId, Class<T> type) {
        this.logger = logger;
        this.ownerId = ownerId;
        this.type = type;
        this.valueSuppliers = NonNullList.func_191196_a();
        this.values = NonNullList.func_191196_a();
        this.registerListeners = NonNullList.func_191196_a();
        this.registryListeners = NonNullList.func_191196_a();
    }

    public boolean initialize(IEventBus bus) {
        this.initialized = true;
        if (!this.valueSuppliers.isEmpty()) {
            bus.addGenericListener(this.type, this::injectRegistryEntries);
            this.logger.debug("Successfully initialized {} registry helper with {} entries.", (Object)this.type.getSimpleName(), (Object)this.valueSuppliers.size());
            return true;
        }
        this.logger.debug("Skipping initialization of {} registry helper. No values detected.", (Object)this.type.getSimpleName());
        return false;
    }

    public T register(T value, String identifier) {
        value.setRegistryName(new ResourceLocation(this.ownerId, identifier));
        return this.register(value);
    }

    public T register(T value) {
        if (value.getRegistryName() == null) {
            throw new IllegalStateException("Attempted to register " + this.type.getSimpleName() + " without registry name: " + value.toString());
        }
        this.register(() -> value);
        this.registerListeners.forEach(listener -> listener.accept(this, value));
        return value;
    }

    public void register(Supplier<T> value) {
        if (this.hasInitialized()) {
            throw new IllegalStateException("The " + this.type.getSimpleName() + " registry helper has already been initialized. New values can not be added.");
        }
        this.valueSuppliers.add(value);
        this.logger.debug("Registered {} entry as {}.", (Object)this.type.getSimpleName(), value);
    }

    public Collection<T> getValues() {
        if (!this.hasRegistered()) {
            throw new IllegalStateException("A mod tried to access the values of a registry before they had been registered!");
        }
        return Collections.unmodifiableCollection(this.values);
    }

    public boolean hasInitialized() {
        return this.initialized;
    }

    public boolean hasRegistered() {
        return this.registered;
    }

    public void addRegisterListener(BiConsumer<ForgeRegistryHelper<T>, T> listener) {
        this.registerListeners.add(listener);
    }

    public void addRegistryListener(BiConsumer<ForgeRegistryHelper<T>, IForgeRegistry<T>> listener) {
        this.registryListeners.add(listener);
    }

    private void injectRegistryEntries(RegistryEvent.Register<T> event) {
        this.values.clear();
        this.registered = false;
        IForgeRegistry registry = event.getRegistry();
        for (Supplier supplier : this.valueSuppliers) {
            IForgeRegistryEntry value = (IForgeRegistryEntry)supplier.get();
            if (value == null) continue;
            registry.register(value);
            this.values.add((Object)value);
        }
        this.registryListeners.forEach(listener -> listener.accept(this, registry));
        this.logger.info("Registered {} {} entries.", (Object)this.values.size(), (Object)this.type.getSimpleName());
        this.registered = true;
    }
}

