/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import net.darkhax.bookshelf.block.IBookshelfBlock;
import net.darkhax.bookshelf.registry.CommandRegistry;
import net.darkhax.bookshelf.registry.ForgeRegistryHelper;
import net.darkhax.bookshelf.registry.ForgeRegistryRegistryHelper;
import net.darkhax.bookshelf.registry.IngredientRegistry;
import net.darkhax.bookshelf.registry.RecipeTypeRegistry;
import net.darkhax.bookshelf.registry.TradeRegistry;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.Logger;

public class RegistryHelper {
    public final String modid;
    public final CommandRegistry commands;
    public final TradeRegistry trades;
    public final RecipeTypeRegistry recipeTypes;
    public final IngredientRegistry ingredients;
    public final ForgeRegistryRegistryHelper registries;
    public final ForgeRegistryHelper<Block> blocks;
    public final ForgeRegistryHelper<Item> items;
    public final ForgeRegistryHelper<TileEntityType<?>> tileEntities;
    public final ForgeRegistryHelper<IRecipeSerializer<?>> recipeSerializers;
    public final ForgeRegistryHelper<ContainerType<?>> containerTypes;
    public final ForgeRegistryHelper<EntityType<?>> entityTypes;
    public final ForgeRegistryHelper<PaintingType> paintings;
    public final ForgeRegistryHelper<Effect> effects;
    public final ForgeRegistryHelper<Potion> potions;
    public final ForgeRegistryHelper<Enchantment> enchantments;
    public final ForgeRegistryHelper<GlobalLootModifierSerializer<?>> lootModifiers;

    public RegistryHelper(String modid, Logger logger) {
        this.modid = modid;
        this.commands = new CommandRegistry(logger);
        this.trades = new TradeRegistry(logger);
        this.recipeTypes = new RecipeTypeRegistry(modid, logger);
        this.ingredients = new IngredientRegistry(modid, logger);
        this.registries = new ForgeRegistryRegistryHelper(modid, logger);
        this.blocks = new ForgeRegistryHelper<Block>(logger, modid, Block.class);
        this.items = new ForgeRegistryHelper<Item>(logger, modid, Item.class);
        this.tileEntities = new ForgeRegistryHelper<TileEntityType>(logger, modid, TileEntityType.class);
        this.recipeSerializers = new ForgeRegistryHelper<IRecipeSerializer>(logger, modid, IRecipeSerializer.class);
        this.containerTypes = new ForgeRegistryHelper<ContainerType>(logger, modid, ContainerType.class);
        this.entityTypes = new ForgeRegistryHelper<EntityType>(logger, modid, EntityType.class);
        this.paintings = new ForgeRegistryHelper<PaintingType>(logger, modid, PaintingType.class);
        this.effects = new ForgeRegistryHelper<Effect>(logger, modid, Effect.class);
        this.potions = new ForgeRegistryHelper<Potion>(logger, modid, Potion.class);
        this.enchantments = new ForgeRegistryHelper<Enchantment>(logger, modid, Enchantment.class);
        this.lootModifiers = new ForgeRegistryHelper<GlobalLootModifierSerializer>(logger, modid, GlobalLootModifierSerializer.class);
        this.blocks.addRegisterListener(this::generateBlockItem);
    }

    public RegistryHelper withItemGroup(ItemGroup group) {
        this.items.addRegisterListener((registry, item) -> {
            item.field_77701_a = group;
        });
        return this;
    }

    public void initialize(IEventBus modBus) {
        this.commands.initialize(modBus);
        this.trades.initialize(modBus);
        this.recipeTypes.initialize(modBus);
        this.ingredients.initialize(modBus);
        this.registries.initialize(modBus);
        this.blocks.initialize(modBus);
        this.items.initialize(modBus);
        this.tileEntities.initialize(modBus);
        this.recipeSerializers.initialize(modBus);
        this.containerTypes.initialize(modBus);
        this.entityTypes.initialize(modBus);
        this.paintings.initialize(modBus);
        this.effects.initialize(modBus);
        this.potions.initialize(modBus);
        this.enchantments.initialize(modBus);
        this.lootModifiers.initialize(modBus);
    }

    private void generateBlockItem(ForgeRegistryHelper<Block> registry, Block block) {
        Item.Properties itemProps;
        Item.Properties properties = itemProps = block instanceof IBookshelfBlock ? ((IBookshelfBlock)block).getItemBlockProperties() : new Item.Properties();
        if (itemProps != null) {
            BlockItem item = new BlockItem(block, itemProps);
            item.setRegistryName(block.getRegistryName());
            this.items.register((Item)item);
        }
    }
}

