/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.PacketBuffer;

public interface ISerializer<T> {
    public T read(JsonElement var1);

    default public T read(JsonObject json, String memberName) {
        return this.read(json.get(memberName));
    }

    default public T read(JsonObject json, String memberName, T fallback) {
        return json.has(memberName) ? this.read(json, memberName) : fallback;
    }

    public JsonElement write(T var1);

    public T read(PacketBuffer var1);

    public void write(PacketBuffer var1, T var2);

    default public List<T> readList(JsonElement json) {
        ArrayList<T> list = new ArrayList<T>();
        if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                list.add(this.read(element));
            }
        } else {
            list.add(this.read(json));
        }
        return list;
    }

    default public List<T> readList(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return this.readList(json.get(memberName));
        }
        throw new JsonParseException("Expected member " + memberName + " was not found.");
    }

    default public List<T> readList(JsonObject json, String memberName, List<T> fallback) {
        return json.has(memberName) ? this.readList(json, memberName) : fallback;
    }

    default public JsonElement writeList(List<T> toWrite) {
        JsonArray json = new JsonArray();
        toWrite.forEach(t -> json.add(this.write(t)));
        return json;
    }

    default public List<T> readList(PacketBuffer buffer) {
        int size = buffer.readInt();
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.read(buffer));
        }
        return list;
    }

    default public void writeList(PacketBuffer buffer, List<T> toWrite) {
        buffer.writeInt(toWrite.size());
        toWrite.forEach(t -> this.write(buffer, t));
    }

    default public Set<T> readSet(JsonElement json) {
        HashSet<T> set = new HashSet<T>();
        if (json.isJsonArray()) {
            for (JsonElement element : json.getAsJsonArray()) {
                set.add(this.read(element));
            }
        } else {
            set.add(this.read(json));
        }
        return set;
    }

    default public Set<T> readSet(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return this.readSet(json.get(memberName));
        }
        throw new JsonParseException("Expected member " + memberName + " was not found.");
    }

    default public Set<T> readSet(JsonObject json, String memberName, Set<T> fallback) {
        return json.has(memberName) ? this.readSet(json, memberName) : fallback;
    }

    default public JsonElement writeSet(Set<T> toWrite) {
        JsonArray json = new JsonArray();
        toWrite.forEach(t -> json.add(this.write(t)));
        return json;
    }

    default public Set<T> readSet(PacketBuffer buffer) {
        int size = buffer.readInt();
        HashSet<T> set = new HashSet<T>(size);
        for (int i = 0; i < size; ++i) {
            set.add(this.read(buffer));
        }
        return set;
    }

    default public void writeSet(PacketBuffer buffer, Set<T> toWrite) {
        buffer.writeInt(toWrite.size());
        toWrite.forEach(t -> this.write(buffer, t));
    }
}

