/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.darkhax.bookshelf.Bookshelf;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SerializerBlockState
implements ISerializer<BlockState> {
    public static final ISerializer<BlockState> SERIALIZER = new SerializerBlockState();

    private SerializerBlockState() {
    }

    @Override
    public BlockState read(JsonElement json) {
        if (json.isJsonObject()) {
            JsonElement properties;
            JsonObject obj = json.getAsJsonObject();
            Block block = Serializers.BLOCK.read(obj, "block");
            BlockState state = block.func_176223_P();
            if (obj.has("properties") && (properties = obj.get("properties")).isJsonObject()) {
                for (Map.Entry property : properties.getAsJsonObject().entrySet()) {
                    state = this.readProperty(state, (String)property.getKey(), (JsonElement)property.getValue());
                }
            }
            return state;
        }
        throw new JsonParseException("Expected properties to be an object. Recieved " + JSONUtils.func_151222_d((JsonElement)json));
    }

    @Override
    public JsonElement write(BlockState toWrite) {
        JsonObject json = new JsonObject();
        json.add("block", Serializers.BLOCK.write(toWrite.func_177230_c()));
        JsonObject properties = new JsonObject();
        for (Property prop : toWrite.func_235904_r_()) {
            if (prop instanceof IntegerProperty) {
                properties.addProperty(prop.func_177701_a(), (Number)((Integer)toWrite.func_177229_b((Property)((IntegerProperty)prop))));
                continue;
            }
            if (prop instanceof BooleanProperty) {
                properties.addProperty(prop.func_177701_a(), Boolean.valueOf((Boolean)toWrite.func_177229_b((Property)((BooleanProperty)prop))));
                continue;
            }
            properties.addProperty(prop.func_177701_a(), prop.func_177702_a(toWrite.func_177229_b(prop)));
        }
        json.add("properties", (JsonElement)properties);
        return json;
    }

    @Override
    public BlockState read(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
        if (block != null) {
            int size = buffer.readInt();
            BlockState state = block.func_176223_P();
            for (int i = 0; i < size; ++i) {
                Optional propValue;
                String propName = buffer.func_218666_n();
                String value = buffer.func_218666_n();
                Property blockProperty = block.func_176194_O().func_185920_a(propName);
                if (blockProperty == null || !(propValue = blockProperty.func_185929_b(value)).isPresent()) continue;
                try {
                    state = (BlockState)state.func_206870_a(blockProperty, (Comparable)propValue.get());
                    continue;
                }
                catch (Exception e) {
                    Bookshelf.LOG.error("Failed to read state for block {}. The mod that adds this block may have issues.", (Object)block.getRegistryName());
                    Bookshelf.LOG.catching((Throwable)e);
                    throw e;
                }
            }
            return state;
        }
        throw new IllegalStateException("Tried to read null block " + id.toString());
    }

    @Override
    public void write(PacketBuffer buffer, BlockState toWrite) {
        buffer.func_192572_a(toWrite.func_177230_c().getRegistryName());
        Collection properties = toWrite.func_235904_r_();
        buffer.writeInt(properties.size());
        for (Property property : properties) {
            buffer.func_180714_a(property.func_177701_a());
            buffer.func_180714_a(toWrite.func_177229_b(property).toString());
        }
    }

    private BlockState readProperty(BlockState state, String propName, JsonElement propValue) {
        Property blockProperty = state.func_177230_c().func_176194_O().func_185920_a(propName);
        if (blockProperty != null) {
            if (propValue.isJsonPrimitive()) {
                String valueString = propValue.getAsString();
                Optional parsedValue = blockProperty.func_185929_b(valueString);
                if (parsedValue.isPresent()) {
                    try {
                        return (BlockState)state.func_206870_a(blockProperty, (Comparable)parsedValue.get());
                    }
                    catch (Exception e) {
                        Bookshelf.LOG.error("Failed to update state for block {}. The mod that adds this block may have an issue.", (Object)state.func_177230_c().getRegistryName());
                        Bookshelf.LOG.catching((Throwable)e);
                        throw e;
                    }
                }
                throw new JsonSyntaxException("The property " + propName + " with value " + valueString + " coul not be parsed!");
            }
            throw new JsonSyntaxException("Expected property value for " + propName + " to be primitive string. Got " + JSONUtils.func_151222_d((JsonElement)propValue));
        }
        throw new JsonSyntaxException("The property " + propName + " is not valid for block " + state.func_177230_c().getRegistryName());
    }
}

