/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class SerializerEnchantmentData
implements ISerializer<EnchantmentData> {
    public static final ISerializer<EnchantmentData> SERIALIZER = new SerializerEnchantmentData();

    private SerializerEnchantmentData() {
    }

    @Override
    public EnchantmentData read(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            Enchantment enchant = Serializers.ENCHANTMENT.read(obj.get("enchantment"));
            int level = JSONUtils.func_151203_m((JsonObject)obj, (String)"level");
            return new EnchantmentData(enchant, level);
        }
        throw new JsonParseException("Expected enchantment data to be a JSON object.");
    }

    @Override
    public JsonElement write(EnchantmentData toWrite) {
        JsonObject json = new JsonObject();
        json.add("enchantment", Serializers.ENCHANTMENT.write(toWrite.field_76302_b));
        json.addProperty("level", (Number)toWrite.field_76303_c);
        return json;
    }

    @Override
    public EnchantmentData read(PacketBuffer buffer) {
        Enchantment enchant = Serializers.ENCHANTMENT.read(buffer);
        int level = buffer.readInt();
        return new EnchantmentData(enchant, level);
    }

    @Override
    public void write(PacketBuffer buffer, EnchantmentData toWrite) {
        Serializers.ENCHANTMENT.write(buffer, toWrite.field_76302_b);
        buffer.writeInt(toWrite.field_76303_c);
    }
}

