/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public final class MathsUtils {
    public static boolean isInRange(double min, double max, double value) {
        return value <= max && value >= min;
    }

    public static double getDistanceBetweenPoints(Vector3d firstPos, Vector3d secondPos) {
        double distanceX = firstPos.field_72450_a - secondPos.field_72450_a;
        double distanceY = firstPos.field_72448_b - secondPos.field_72448_b;
        double distanceZ = firstPos.field_72449_c - secondPos.field_72449_c;
        return Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
    }

    public static double round(double value, int places) {
        return value >= 0.0 && places > 0 ? BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).doubleValue() : value;
    }

    public static int nextIntInclusive(Random rand, int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static boolean tryPercentage(double percent) {
        return Math.random() < percent;
    }

    public static int getAverage(int first, int second) {
        return Math.round((float)(first + second) / 2.0f);
    }

    public static String ticksToTime(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        return minutes + ":" + seconds;
    }

    public static int getPercentage(int value, int total) {
        return (int)((float)value / (float)total * 100.0f);
    }

    public static double getPixelDistance(int pixels) {
        return (double)pixels / 16.0;
    }

    public static AxisAlignedBB getBoundsForPixels(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new AxisAlignedBB(MathsUtils.getPixelDistance(minX), MathsUtils.getPixelDistance(minY), MathsUtils.getPixelDistance(minZ), MathsUtils.getPixelDistance(maxX), MathsUtils.getPixelDistance(maxY), MathsUtils.getPixelDistance(maxZ));
    }

    public static int adjustToRange(int initial, int min, int max) {
        return initial < min ? min : (initial > max ? max : initial);
    }

    public static int multiplyColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

