/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.asm;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.asm.InstructionComparator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public final class ASMUtils {
    public static boolean isSrg = true;
    public static boolean isASMEnabled = false;

    public static String getAppropriateMapping(String mcp, String srg) {
        return isSrg ? srg : mcp;
    }

    public static byte[] createByteArrayFromClass(ClassNode classNode, int flags) {
        ClassWriter classWriter = new ClassWriter(flags);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public static ClassNode createClassFromByteArray(byte[] classBytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classNode, 8);
        return classNode;
    }

    public static boolean hasClassMethodName(ClassNode classNode, String methodName) {
        for (MethodNode method : classNode.methods) {
            if (!methodName.equals(method.name)) continue;
            return true;
        }
        return false;
    }

    public static MethodNode getMethodFromClass(ClassNode classNode, String methodName, String descriptor) {
        for (MethodNode mnode : classNode.methods) {
            if (!methodName.equals(mnode.name) || !descriptor.equals(mnode.desc)) continue;
            return mnode;
        }
        throw new MethodNotFoundException(methodName, descriptor);
    }

    public static AbstractInsnNode findFirstNodeFromNeedle(InsnList haystack, InsnList needle) {
        List<AbstractInsnNode> ret = InstructionComparator.insnListFindStart(haystack, needle);
        if (ret.size() != 1) {
            throw new InvalidNeedleException(ret.size());
        }
        return ret.get(0);
    }

    public static AbstractInsnNode findLastNodeFromNeedle(InsnList haystack, InsnList needle) {
        List<AbstractInsnNode> ret = InstructionComparator.insnListFindEnd(haystack, needle);
        if (ret.size() != 1) {
            throw new InvalidNeedleException(ret.size());
        }
        return ret.get(0);
    }

    public static void removeNeedleFromHaystack(InsnList haystack, InsnList needle) {
        int firstInd = haystack.indexOf(ASMUtils.findFirstNodeFromNeedle(haystack, needle));
        int lastInd = haystack.indexOf(ASMUtils.findLastNodeFromNeedle(haystack, needle));
        ArrayList<AbstractInsnNode> realNeedle = new ArrayList<AbstractInsnNode>();
        for (int i = firstInd; i <= lastInd; ++i) {
            realNeedle.add(haystack.get(i));
        }
        for (AbstractInsnNode node : realNeedle) {
            haystack.remove(node);
        }
    }

    public static boolean canIgnoreInstruction(AbstractInsnNode insn) {
        return insn instanceof LabelNode || insn instanceof LineNumberNode;
    }

    public static class MethodNotFoundException
    extends RuntimeException {
        public MethodNotFoundException(String methodName, String methodDesc) {
            super("Attempt to find a method has failed. Method: " + methodName + " Descriptor: " + methodDesc);
        }
    }

    public static class InvalidNeedleException
    extends RuntimeException {
        public InvalidNeedleException(int count) {
            super(count > 1 ? "More than one instance of the needle have been found!" : (count < 1 ? "The needle was not found" : "There is a glitch in the matrix"));
        }
    }
}

