/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client;

import net.darkhax.bookshelf.client.particle.OpenEntityDiggingFX;
import net.darkhax.bookshelf.lib.Constants;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    public static boolean registerEntityLayer(Class<? extends Entity> entityClass, LayerRenderer layer) {
        RendererLivingEntity renderer = RenderUtils.getEntityRenderer(entityClass);
        if (renderer != null) {
            renderer.func_177094_a(layer);
            return true;
        }
        return false;
    }

    public static RendererLivingEntity getEntityRenderer(Class<? extends Entity> entityClass) {
        Render renderer = (Render)Minecraft.func_71410_x().func_175598_ae().field_78729_o.get(entityClass);
        return renderer instanceof RendererLivingEntity ? (RendererLivingEntity)renderer : null;
    }

    public static void registerPlayerLayer(LayerRenderer layer) {
        RenderUtils.getSteveRenderer().func_177094_a(layer);
        RenderUtils.getAlexRenderer().func_177094_a(layer);
    }

    public static RenderPlayer getSteveRenderer() {
        return RenderUtils.getPlayerRenderer("default");
    }

    public static RenderPlayer getAlexRenderer() {
        return RenderUtils.getPlayerRenderer("slim");
    }

    public static RenderPlayer getPlayerRenderer(String type) {
        return (RenderPlayer)Minecraft.func_71410_x().func_175598_ae().field_178636_l.get(type);
    }

    public static boolean setPlayerSkin(AbstractClientPlayer player, ResourceLocation skin) {
        if (player.func_152122_n() && skin != null) {
            player.func_175155_b().field_178865_e = skin;
            return true;
        }
        return false;
    }

    public static boolean setPlayerCape(AbstractClientPlayer player, ResourceLocation cape) {
        if (player.func_152122_n() && cape != null) {
            player.func_175155_b().field_178862_f = cape;
            return true;
        }
        return false;
    }

    public static boolean spawnDigParticles(EffectRenderer renderer, IBlockState state, World world, BlockPos pos, EnumFacing side) {
        Block block = state.func_177230_c();
        if (block != null && block.func_149645_b() != -1) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            float offset = 0.1f;
            double xOffset = (double)x + Constants.RANDOM.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(offset * 2.0f)) + (double)offset + block.func_149704_x();
            double yOffset = (double)y + Constants.RANDOM.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(offset * 2.0f)) + (double)offset + block.func_149665_z();
            double zOffset = (double)z + Constants.RANDOM.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(offset * 2.0f)) + (double)offset + block.func_149706_B();
            if (side == EnumFacing.DOWN) {
                yOffset = (double)y + block.func_149665_z() - (double)offset;
            } else if (side == EnumFacing.UP) {
                yOffset = (double)y + block.func_149669_A() + (double)offset;
            } else if (side == EnumFacing.NORTH) {
                zOffset = (double)z + block.func_149706_B() - (double)offset;
            } else if (side == EnumFacing.SOUTH) {
                zOffset = (double)z + block.func_149693_C() + (double)offset;
            } else if (side == EnumFacing.WEST) {
                xOffset = (double)x + block.func_149704_x() - (double)offset;
            } else if (side == EnumFacing.EAST) {
                xOffset = (double)x + block.func_149753_y() + (double)offset;
            }
            renderer.func_78873_a(new OpenEntityDiggingFX(world, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0, state).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
            return true;
        }
        return false;
    }

    public static boolean spawnBreakParticles(EffectRenderer renderer, IBlockState state, World world, BlockPos pos) {
        if (state.func_177230_c() != null) {
            int multiplier = 4;
            for (int xOffset = 0; xOffset < multiplier; ++xOffset) {
                for (int yOffset = 0; yOffset < multiplier; ++yOffset) {
                    for (int zOffset = 0; zOffset < multiplier; ++zOffset) {
                        double xPos = (double)pos.func_177958_n() + ((double)xOffset + 0.5) / (double)multiplier;
                        double yPos = (double)pos.func_177956_o() + ((double)yOffset + 0.5) / (double)multiplier;
                        double zPos = (double)pos.func_177952_p() + ((double)zOffset + 0.5) / (double)multiplier;
                        renderer.func_78873_a((EntityFX)new OpenEntityDiggingFX(world, xPos, yPos, zPos, xPos - (double)pos.func_177958_n() - 0.5, yPos - (double)pos.func_177956_o() - 0.5, zPos - (double)pos.func_177952_p() - 0.5, state).func_174846_a(pos));
                    }
                }
            }
            return true;
        }
        return false;
    }
}

