/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import java.util.Arrays;
import java.util.List;
import net.darkhax.bookshelf.lib.util.MathsUtils;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.WordUtils;

public final class Utilities {
    private static String[] vanillaVillagers = new String[]{"farmer", "librarian", "priest", "blacksmith", "butcher"};
    public static String[] vanillaLootChests = new String[]{"dungeonChest", "bonusChest", "villageBlacksmith", "strongholdCrossing", "strongholdLibrary", "strongholdCorridor", "pyramidJungleDispenser", "pyramidJungleChest", "pyramidDesertyChest", "mineshaftCorridor"};
    public static String[] rainbowChars = new String[]{"4", "6", "e", "a", "9", "5"};
    public static int[] validKeys = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 71, 72, 73, 75, 76, 77, 79, 80, 81};

    public static List<String> wrapStringToList(String string, int lnLength, boolean wrapLongWords, List<String> list) {
        String[] lines = WordUtils.wrap((String)string, (int)lnLength, null, (boolean)wrapLongWords).split(SystemUtils.LINE_SEPARATOR);
        list.addAll(Arrays.asList(lines));
        return list;
    }

    public static List<String> wrapStringToListWithFormat(String string, int lnLength, boolean wrapLongWords, List<String> list, EnumChatFormatting format) {
        String[] lines;
        for (String line : lines = WordUtils.wrap((String)string, (int)lnLength, null, (boolean)wrapLongWords).split(SystemUtils.LINE_SEPARATOR)) {
            list.add(format + line);
        }
        return list;
    }

    public static boolean isFluid(Block block) {
        return block == Blocks.field_150353_l || block == Blocks.field_150355_j || block instanceof IFluidBlock;
    }

    public static Object getThingByName(String name) {
        ResourceLocation location = new ResourceLocation(name);
        Object thing = Item.field_150901_e.func_82594_a((Object)location);
        if (thing != null) {
            return thing;
        }
        thing = Block.field_149771_c.func_82594_a((Object)location);
        if (thing != null) {
            return thing;
        }
        return null;
    }

    public static boolean compareClasses(Class class1, Class class2) {
        return class1 != null && class2 != null && class1.getName().equalsIgnoreCase(class2.getName());
    }

    public static boolean compareObjectToClass(Object obj, Class clazz) {
        return Utilities.compareClasses(obj.getClass(), clazz);
    }

    public static String makeUpperCased(String text) {
        return Character.toString(text.charAt(0)).toUpperCase() + text.substring(1);
    }

    public static Class getClassFromString(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isWearingFullSet(EntityLivingBase living, Class armorClass) {
        for (int armorSlot = 1; armorSlot <= 4; ++armorSlot) {
            ItemStack armor = living.func_71124_b(armorSlot);
            if (armor != null && armor.func_77973_b().getClass().equals(armorClass)) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getCustomHorseArmor(EntityHorse horse) {
        return horse.func_70096_w().func_82710_f(23);
    }

    public static void setCustomHorseArmor(EntityHorse horse, ItemStack stack) {
        horse.func_70096_w().func_75692_b(23, (Object)stack);
    }

    public static String getModName(Item item) {
        String itemID = GameData.getItemRegistry().getNameForObject((Object)item).toString();
        return itemID.substring(0, itemID.indexOf(58));
    }

    public static String getModName(Block block) {
        String blockID = GameData.getBlockRegistry().getNameForObject((Object)block).toString();
        return blockID.substring(0, blockID.indexOf(58));
    }

    public static void spawnParticleRing(World world, EnumParticleTypes particle, double x, double y, double z, double velocityX, double velocityY, double velocityZ, double step) {
        for (double degree = 0.0; degree < Math.PI * 2; degree += step) {
            world.func_175688_a(particle, x + Math.cos(degree), y, z + Math.sin(degree), velocityX, velocityY, velocityZ, new int[0]);
        }
    }

    public static void spawnParticleRing(World world, EnumParticleTypes particle, float percentage, double x, double y, double z, double velocityX, double velocityY, double velocityZ, double step) {
        for (double degree = 0.0; degree < Math.PI * 2 * (double)percentage; degree += step) {
            world.func_175688_a(particle, x + Math.cos(degree), y, z + Math.sin(degree), velocityX, velocityY, velocityZ, new int[0]);
        }
    }

    public static String getTicksAstime(int timeInTicks) {
        float time = (float)timeInTicks / 20.0f;
        return MathsUtils.round(time, 2) + (time == 1.0f ? " Second " : "Seconds");
    }

    public static boolean isKeyCodeNumeric(int keyCode) {
        for (int validKey : validKeys) {
            if (validKey != keyCode) continue;
            return true;
        }
        return false;
    }

    public static Potion getPotionByID(int id) {
        if (id >= 0 && id < Potion.field_76425_a.length) {
            return Potion.field_76425_a[id];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getVillagerName(int id) {
        ResourceLocation skin = VillagerRegistry.getVillagerSkin((int)id, null);
        return id >= 0 && id <= 4 ? vanillaVillagers[id] : (skin != null ? skin.func_110624_b() + "." + skin.func_110623_a().substring(skin.func_110623_a().lastIndexOf("/") + 1, skin.func_110623_a().length() - 4) : "misingno");
    }

    @SideOnly(value=Side.CLIENT)
    public static CreativeTabs getTabFromLabel(String label) {
        for (CreativeTabs tab : CreativeTabs.field_78032_a) {
            if (!tab.func_78013_b().equalsIgnoreCase(label)) continue;
            return tab;
        }
        return null;
    }
}

