/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.tools.VoxelShapeTools;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockGasStationTop
extends BlockBase {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static VoxelShape SHAPE_NORTH_SOUTH = Block.func_208617_a((double)2.0, (double)-16.0, (double)5.0, (double)14.0, (double)15.0, (double)11.0);
    public static VoxelShape SHAPE_NEAST_WEST = Block.func_208617_a((double)5.0, (double)-16.0, (double)2.0, (double)11.0, (double)15.0, (double)14.0);
    public static VoxelShape SHAPE_SLAB = Block.func_208617_a((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-8.0, (double)16.0);
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapeTools.combine(SHAPE_NORTH_SOUTH, SHAPE_SLAB), (Object)Direction.SOUTH, (Object)VoxelShapeTools.combine(SHAPE_NORTH_SOUTH, SHAPE_SLAB), (Object)Direction.EAST, (Object)VoxelShapeTools.combine(SHAPE_NEAST_WEST, SHAPE_SLAB), (Object)Direction.WEST, (Object)VoxelShapeTools.combine(SHAPE_NEAST_WEST, SHAPE_SLAB)));

    public BlockGasStationTop() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(4.0f).func_200947_a(SoundType.field_185852_e));
        this.setRegistryName(new ResourceLocation("car", "gas_station_top"));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return ModBlocks.FUEL_STATION.func_225533_a_(worldIn.func_180495_p(pos.func_177977_b()), worldIn, pos.func_177977_b(), player, handIn, hit);
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            BlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
            if (stateDown != null && stateDown.func_177230_c().equals(ModBlocks.FUEL_STATION)) {
                worldIn.func_175655_b(pos.func_177977_b(), false);
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        BlockState stateDown = world.func_180495_p(pos.func_177977_b());
        if (stateDown != null && stateDown.func_177230_c() != null && stateDown.func_177230_c().equals(ModBlocks.FUEL_STATION) && !player.field_71075_bZ.field_75098_d) {
            ModBlocks.FUEL_STATION.func_180657_a(world, player, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()), world.func_175625_s(pos.func_177977_b()), player.func_184614_ca());
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        BlockState stateDown = world.func_180495_p(pos.func_177977_b());
        if (stateDown != null && stateDown.func_177230_c() != null && stateDown.func_177230_c().equals(ModBlocks.FUEL_STATION)) {
            return ModBlocks.FUEL_STATION.getPickBlock(stateDown, target, world, pos.func_177977_b(), player);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }
}

