/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.tools.IItemBlock;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

public abstract class BlockGui<T extends TileEntity>
extends BlockBase
implements ITileEntityProvider,
IItemBlock {
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);

    protected BlockGui(String name, Material material, SoundType soundType, float hardness, float resistance) {
        this(name, Block.Properties.func_200949_a((Material)material, (MaterialColor)MaterialColor.field_151668_h).func_200948_a(hardness, resistance).func_200947_a(soundType));
    }

    protected BlockGui(String name, Block.Properties properties) {
        super(properties);
        this.setRegistryName(new ResourceLocation("car", name));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ModItemGroups.TAB_CAR)).setRegistryName(this.getRegistryName());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_225608_bj_()) {
            if (!(player instanceof ServerPlayerEntity)) {
                return ActionResultType.SUCCESS;
            }
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            try {
                TileEntity tile = tileEntity;
                this.openGui(state, worldIn, pos, (ServerPlayerEntity)player, handIn, tile);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public abstract void openGui(BlockState var1, World var2, BlockPos var3, ServerPlayerEntity var4, Hand var5, T var6);

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (state.func_177230_c() != newState.func_177230_c() && tileentity != null && tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, POWERED});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void setPowered(World world, BlockPos pos, BlockState state, boolean powered) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).equals(powered)) {
            return;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_175690_a(pos, tileentity);
        }
    }
}

