/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.tools.BlockPosList;
import de.maxhenkel.tools.EnergyTools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityCable
extends TileEntityBase
implements ITickableTileEntity,
IEnergyStorage {
    private final int transferRate;

    public TileEntityCable(int transferRate) {
        super(Main.CABLE_TILE_ENTITY_TYPE);
        this.transferRate = transferRate;
    }

    public TileEntityCable() {
        this((Integer)Config.cableTransferRate.get());
    }

    public void func_73660_a() {
        int energy = 0;
        ArrayList<IEnergyStorage> providers = new ArrayList<IEnergyStorage>();
        for (Direction facing : Direction.values()) {
            IEnergyStorage provider = EnergyTools.getEnergyStorageOffset((IWorldReader)this.field_145850_b, this.field_174879_c, facing);
            if (provider == null || provider instanceof TileEntityCable) continue;
            int cex = Math.max(0, this.transferRate - energy);
            if (cex <= 0) break;
            int extract = provider.extractEnergy(cex, true);
            if (extract <= 0) continue;
            energy += extract;
            providers.add(provider);
        }
        if (energy <= 0) {
            return;
        }
        ArrayList<IEnergyStorage> receivers = new ArrayList<IEnergyStorage>();
        this.getConnectedReceivers(providers, receivers, new BlockPosList(), this.field_174879_c);
        if (receivers.size() <= 0) {
            return;
        }
        int split = energy / receivers.size();
        if (split <= 0) {
            return;
        }
        int received = 0;
        for (IEnergyStorage entry : receivers) {
            received += entry.receiveEnergy(split, false);
        }
        for (IEnergyStorage entry : providers) {
            if (received <= 0) break;
            received -= entry.extractEnergy(received, false);
        }
    }

    public void getConnectedReceivers(List<IEnergyStorage> sources, List<IEnergyStorage> receivers, BlockPosList positions, BlockPos pos) {
        for (Direction side : Direction.values()) {
            BlockPos p = pos.func_177972_a(side);
            if (positions.contains(p)) continue;
            BlockState state = this.field_145850_b.func_180495_p(p);
            if (state.func_177230_c().equals(ModBlocks.CABLE)) {
                positions.add(p);
                this.getConnectedReceivers(sources, receivers, positions, p);
                continue;
            }
            IEnergyStorage storage = EnergyTools.getEnergyStorageOffset((IWorldReader)this.field_145850_b, pos, side);
            if (storage == null || storage.equals((Object)this) || sources.contains(storage) || receivers.contains(storage)) continue;
            receivers.add(storage);
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent("block.car.cable", new Object[0]);
    }

    @Override
    public IIntArray getFields() {
        return new IntArray(0);
    }
}

