/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.tools.EnergyTools;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityDynamo
extends TileEntityBase
implements IEnergyStorage,
ITickableTileEntity {
    private int storedEnergy = 0;
    public final int maxStorage = (Integer)Config.dynamoEnergyStorage.get();
    public final int generation = (Integer)Config.dynamoEnergyGeneration.get();

    public TileEntityDynamo() {
        super(Main.DYNAMO_TILE_ENTITY_TYPE);
    }

    public void func_73660_a() {
        for (Direction side : Direction.values()) {
            IEnergyStorage storage = EnergyTools.getEnergyStorageOffset((IWorldReader)this.field_145850_b, this.field_174879_c, side);
            if (storage == null) continue;
            EnergyTools.pushEnergy(this, storage, this.storedEnergy, side.func_176734_d(), side);
        }
    }

    public void addEnergy(int energy) {
        this.storedEnergy += energy;
        if (this.storedEnergy > this.maxStorage) {
            this.storedEnergy = this.maxStorage;
        }
        this.func_70296_d();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("stored_energy", this.storedEnergy);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.storedEnergy = compound.func_74762_e("stored_energy");
        super.func_145839_a(compound);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int i = Math.min(maxExtract, this.storedEnergy);
        if (!simulate) {
            this.storedEnergy -= i;
            this.func_70296_d();
        }
        return i;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent("block.car.dynamo", new Object[0]);
    }

    @Override
    public IIntArray getFields() {
        return new IntArray(0);
    }
}

