/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockFluidExtractor;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.tools.BlockPosList;
import de.maxhenkel.tools.FluidUtils;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidExtractor
extends TileEntityBase
implements ITickableTileEntity {
    private IFluidHandler extractHandler;
    private final int drainSpeed = (Integer)Config.fluidExtractorDrainSpeed.get();
    private ItemStack filter = null;

    public TileEntityFluidExtractor() {
        super(Main.FLUID_EXTRACTOR_TILE_ENTITY_TYPE);
    }

    @Nullable
    public Fluid getFilterFluid() {
        if (this.filter == null) {
            return null;
        }
        FluidStack stack = (FluidStack)FluidUtil.getFluidContained((ItemStack)this.filter).orElse(null);
        if (stack == null || stack.getAmount() <= 0) {
            return null;
        }
        return stack.getFluid();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateExtractHandler();
        if (this.extractHandler == null) {
            return;
        }
        FluidStack drainSimulated = this.getFilterFluid() == null ? this.extractHandler.drain(this.drainSpeed, IFluidHandler.FluidAction.SIMULATE) : this.extractHandler.drain(new FluidStack(this.getFilterFluid(), this.drainSpeed), IFluidHandler.FluidAction.SIMULATE);
        if (drainSimulated == null || drainSimulated.getAmount() <= 0) {
            return;
        }
        LinkedList<IFluidHandler> handlers = new LinkedList<IFluidHandler>();
        this.getConnectedHandlers(handlers, new BlockPosList(), this.field_174879_c);
        LinkedList<IFluidHandler> fillHandlers = new LinkedList<IFluidHandler>();
        for (IFluidHandler handler : handlers) {
            int amount = handler.fill(drainSimulated, IFluidHandler.FluidAction.SIMULATE);
            if (amount <= 0) continue;
            fillHandlers.add(handler);
        }
        if (fillHandlers.isEmpty()) {
            return;
        }
        for (IFluidHandler handler : fillHandlers) {
            if (this.getFilterFluid() == null) {
                FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this.extractHandler, (int)this.drainSpeed, (boolean)true);
                continue;
            }
            FluidUtils.tryFluidTransfer(handler, this.extractHandler, this.drainSpeed, true, this.getFilterFluid());
        }
    }

    public void updateExtractHandler() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!state.func_177230_c().equals(ModBlocks.FLUID_EXTRACTOR)) {
            this.extractHandler = null;
            return;
        }
        Direction side = (Direction)state.func_177229_b((IProperty)BlockFluidExtractor.FACING);
        this.extractHandler = FluidUtils.getFluidHandler((IWorldReader)this.field_145850_b, this.field_174879_c, side);
    }

    public void getConnectedHandlers(List<IFluidHandler> handlers, BlockPosList positions, BlockPos pos) {
        for (Direction side : Direction.values()) {
            BlockPos p = pos.func_177972_a(side);
            if (positions.contains(p)) continue;
            BlockState state = this.field_145850_b.func_180495_p(p);
            if (state.func_177230_c().equals(ModBlocks.FLUID_PIPE) || state.func_177230_c().equals(ModBlocks.FLUID_EXTRACTOR)) {
                positions.add(p);
                this.getConnectedHandlers(handlers, positions, p);
                continue;
            }
            IFluidHandler handler = FluidUtils.getFluidHandler((IWorldReader)this.field_145850_b, pos, side);
            if (handler == null || handler.equals(this.extractHandler)) continue;
            handlers.add(handler);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.filter != null) {
            CompoundNBT tag = new CompoundNBT();
            this.filter.func_77955_b(tag);
            compound.func_218657_a("filter", (INBT)tag);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        if (compound.func_74764_b("filter")) {
            CompoundNBT tag = compound.func_74775_l("filter");
            this.filter = ItemStack.func_199557_a((CompoundNBT)tag);
        } else {
            this.filter = null;
        }
        super.func_145839_a(compound);
    }

    @Override
    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent("block.car.fluid_extractor", new Object[0]);
    }

    public ItemStack getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.func_77946_l();
    }

    public void setFilter(ItemStack filter) {
        if (filter == null) {
            this.filter = null;
            this.func_70296_d();
            this.synchronize();
            return;
        }
        this.filter = filter.func_77946_l();
        this.func_70296_d();
        this.synchronize();
    }

    @Override
    public IIntArray getFields() {
        return new IntArray(0);
    }
}

