/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.tools.RenderTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ILightReader;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySpecialRendererTank
extends TileEntityRenderer<TileEntityTank> {
    public static final ResourceLocation LOCATION_TANK = new ResourceLocation("car", "textures/block/tank_line.png");

    public TileEntitySpecialRendererTank(TileEntityRendererDispatcher tileEntityRendererDispatcher) {
        super(tileEntityRendererDispatcher);
    }

    public void render(TileEntityTank te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        matrixStack.func_227860_a_();
        float amount = te.getFillPercent();
        FluidStack stack = te.getFluid();
        if (amount > 0.0f && stack != null) {
            this.renderFluid(te, stack, amount, 0.0f, matrixStack, buffer, light, overlay);
        }
        TileEntitySpecialRendererTank.renderLines(te, matrixStack, buffer, light, overlay);
        matrixStack.func_227865_b_();
    }

    public void renderFluid(TileEntityTank tank, FluidStack fluid, float amount, float yStart, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        matrixStack.func_227860_a_();
        IVertexBuilder builder = buffer.getBuffer(Atlases.func_228784_i_());
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(fluid.getFluid().getAttributes().getStillTexture());
        float uMin = texture.func_94209_e();
        float uMax = texture.func_94212_f();
        float vMin = texture.func_94206_g();
        float vMax = texture.func_94210_h();
        float vHeight = vMax - vMin;
        int i = tank.func_145830_o() ? fluid.getFluid().getAttributes().getColor((ILightReader)tank.func_145831_w(), tank.func_174877_v()) : fluid.getFluid().getAttributes().getColor();
        int red = i >> 16 & 0xFF;
        int green = i >> 8 & 0xFF;
        int blue = i & 0xFF;
        float s = 0.0f;
        if (!tank.isFluidConnected(Direction.NORTH)) {
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 0.0f - s, yStart, 0.0f + s, uMin, vMin, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.SOUTH)) {
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMax, vMin, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.EAST)) {
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMin, vMin, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMax, vMin, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.WEST)) {
            RenderTools.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.DOWN)) {
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMin, vMax, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMax, vMax, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.UP)) {
            RenderTools.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMax, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMax, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderTools.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
        }
        matrixStack.func_227865_b_();
    }

    public static void renderLines(TileEntityTank te, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay) {
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)LOCATION_TANK));
        for (Direction facing : Direction.values()) {
            if (te.isTankConnectedTo(facing)) continue;
            for (EnumDirection direction : EnumDirection.values()) {
                if (te.isTankConnectedTo(direction.to(facing))) continue;
                TileEntitySpecialRendererTank.drawLine(facing, direction, matrixStack, buffer, builder, light, overlay);
            }
        }
    }

    public static void drawLine(Direction side, EnumDirection line, MatrixStack matrixStack, IRenderTypeBuffer buffer, IVertexBuilder builder, int light, int overlay) {
        matrixStack.func_227860_a_();
        TileEntitySpecialRendererTank.rotate(side, matrixStack);
        matrixStack.func_227861_a_(-2.5E-4, -2.5E-4, -2.5E-4);
        TileEntitySpecialRendererTank.drawSide(line, side, matrixStack, buffer, builder, light, overlay);
        matrixStack.func_227865_b_();
    }

    public static void rotate(Direction facing, MatrixStack matrixStack) {
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        switch (facing) {
            case SOUTH: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                break;
            }
            case EAST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                break;
            }
            case UP: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                break;
            }
            case DOWN: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(270.0f));
                break;
            }
        }
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
    }

    public static void drawSide(EnumDirection line, Direction side, MatrixStack matrixStack, IRenderTypeBuffer buffer, IVertexBuilder builder, int light, int overlay) {
        switch (line) {
            case UP: {
                RenderTools.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                break;
            }
            case DOWN: {
                RenderTools.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                break;
            }
            case RIGHT: {
                RenderTools.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                break;
            }
            case LEFT: {
                RenderTools.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                RenderTools.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                break;
            }
        }
    }

    public static enum EnumDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;


        public Direction to(Direction facing) {
            switch (facing) {
                case NORTH: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.EAST;
                        }
                        case RIGHT: {
                            return Direction.WEST;
                        }
                    }
                }
                case SOUTH: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.WEST;
                        }
                        case RIGHT: {
                            return Direction.EAST;
                        }
                    }
                }
                case EAST: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.SOUTH;
                        }
                        case RIGHT: {
                            return Direction.NORTH;
                        }
                    }
                }
                case WEST: {
                    switch (this) {
                        case UP: {
                            return Direction.UP;
                        }
                        case DOWN: {
                            return Direction.DOWN;
                        }
                        case LEFT: {
                            return Direction.NORTH;
                        }
                        case RIGHT: {
                            return Direction.SOUTH;
                        }
                    }
                }
                case UP: {
                    switch (this) {
                        case UP: {
                            return Direction.NORTH;
                        }
                        case DOWN: {
                            return Direction.SOUTH;
                        }
                        case LEFT: {
                            return Direction.WEST;
                        }
                        case RIGHT: {
                            return Direction.EAST;
                        }
                    }
                }
                case DOWN: {
                    switch (this) {
                        case UP: {
                            return Direction.SOUTH;
                        }
                        case DOWN: {
                            return Direction.NORTH;
                        }
                        case LEFT: {
                            return Direction.WEST;
                        }
                        case RIGHT: {
                            return Direction.EAST;
                        }
                    }
                }
            }
            return Direction.UP;
        }
    }
}

