/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.fluids.ModFluids;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EntityCarFuelBase
extends EntityCarDamageBase
implements IFluidHandler {
    private static final DataParameter<Integer> FUEL_AMOUNT = EntityDataManager.func_187226_a(EntityCarFuelBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> FUEL_TYPE = EntityDataManager.func_187226_a(EntityCarFuelBase.class, (IDataSerializer)DataSerializers.field_187194_d);

    public EntityCarFuelBase(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public abstract int getMaxFuel();

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.fuelTick();
    }

    protected int calculateTickFuel() {
        float efficiency = this.getEfficiency(this.getFluid());
        int ticks = (int)((double)efficiency * 100.0);
        if (ticks <= 0) {
            ticks = 1;
        }
        return ticks;
    }

    protected void fuelTick() {
        float fuel = this.getFuelAmount();
        int tickFuel = this.calculateTickFuel();
        if (fuel > 0.0f && this.isAccelerating()) {
            if (this.field_70173_aa % tickFuel == 0) {
                this.acceleratingFuelTick();
            }
        } else if (fuel > 0.0f && this.isStarted() && this.field_70173_aa % (tickFuel * 100) == 0) {
            this.idleFuelTick();
        }
    }

    protected void idleFuelTick() {
        this.removeFuel(1);
    }

    protected void acceleratingFuelTick() {
        this.removeFuel(1);
    }

    private void removeFuel(int amount) {
        int fuel = this.getFuelAmount();
        int newFuel = fuel - amount;
        if (newFuel <= 0) {
            this.setFuelAmount(0);
        } else {
            this.setFuelAmount(newFuel);
        }
    }

    @Override
    public boolean canPlayerDriveCar(PlayerEntity player) {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canPlayerDriveCar(player);
    }

    @Override
    public boolean canStartCarEngine(PlayerEntity player) {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canStartCarEngine(player);
    }

    @Override
    public boolean canEngineStayOn() {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canEngineStayOn();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FUEL_AMOUNT, (Object)0);
        this.field_70180_af.func_187214_a(FUEL_TYPE, (Object)new String());
    }

    public void setFuelAmount(int fuel) {
        this.field_70180_af.func_187227_b(FUEL_AMOUNT, (Object)fuel);
    }

    public void setFuelType(String fluid) {
        if (fluid == null) {
            fluid = "";
        }
        this.field_70180_af.func_187227_b(FUEL_TYPE, (Object)fluid);
    }

    public void setFuelType(Fluid fluid) {
        this.setFuelType(fluid.getRegistryName().toString());
    }

    public String getFuelType() {
        return (String)this.field_70180_af.func_187225_a(FUEL_TYPE);
    }

    @Nullable
    public Fluid getFluid() {
        String fuelType = this.getFuelType();
        if (fuelType == null || fuelType.isEmpty()) {
            return null;
        }
        return (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fuelType));
    }

    public int getFuelAmount() {
        return (Integer)this.field_70180_af.func_187225_a(FUEL_AMOUNT);
    }

    public boolean isValidFuel(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return this.getEfficiency(fluid) > 0.0f;
    }

    public abstract float getEfficiency(@Nullable Fluid var1);

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("fuel", this.getFuelAmount());
        compound.func_74778_a("fuel_type", this.getFuelType());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFuelAmount(compound.func_74762_e("fuel"));
        if (compound.func_74764_b("fuel_type")) {
            this.setFuelType(compound.func_74779_i("fuel_type"));
        }
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        Fluid f = this.getFluid();
        if (f == null) {
            return new FluidStack((Fluid)ModFluids.BIO_DIESEL, this.getFuelAmount());
        }
        return new FluidStack(f, this.getFuelAmount());
    }

    public int getTankCapacity(int tank) {
        return this.getMaxFuel();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFuel(stack.getFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || !this.isValidFuel(resource.getFluid())) {
            return 0;
        }
        if (this.getFluid() != null && this.getFuelAmount() > 0 && !resource.getFluid().equals(this.getFluid())) {
            return 0;
        }
        int amount = Math.min(resource.getAmount(), this.getMaxFuel() - this.getFuelAmount());
        if (action.execute()) {
            int i = this.getFuelAmount() + amount;
            if (i > this.getMaxFuel()) {
                i = this.getMaxFuel();
            }
            this.setFuelAmount(i);
            this.setFuelType(resource.getFluid());
        }
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null) {
            return FluidStack.EMPTY;
        }
        if (resource.getFluid() == null || !resource.getFluid().equals(this.getFluid())) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        Fluid fluid = this.getFluid();
        int totalAmount = this.getFuelAmount();
        if (fluid == null) {
            return null;
        }
        int amount = Math.min(maxDrain, totalAmount);
        if (action.execute()) {
            int newAmount = totalAmount - amount;
            if (newAmount <= 0) {
                this.setFuelType((String)null);
                this.setFuelAmount(0);
            } else {
                this.setFuelAmount(newAmount);
            }
        }
        return new FluidStack(fluid, amount);
    }
}

