/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarLockBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.parts.PartLicensePlateHolder;
import de.maxhenkel.car.items.ItemLicensePlate;
import de.maxhenkel.tools.ItemTools;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class EntityCarLicensePlateBase
extends EntityCarLockBase {
    private static final DataParameter<String> LICENSE_PLATE = EntityDataManager.func_187226_a(EntityCarLicensePlateBase.class, (IDataSerializer)DataSerializers.field_187194_d);

    public EntityCarLicensePlateBase(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LICENSE_PLATE, (Object)"");
    }

    @Override
    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        String text;
        ItemStack stack;
        if (player.func_225608_bj_() && !this.isLocked() && this.hasLicensePlateHolder() && (stack = player.func_184586_b(hand)).func_77973_b() instanceof ItemLicensePlate && (text = ItemLicensePlate.getText(stack)) != null && !text.isEmpty()) {
            ItemTools.decrItemStack(stack, player);
            player.func_184611_a(hand, stack);
            this.setLicensePlate(text);
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public boolean hasLicensePlateHolder() {
        if (!(this instanceof EntityGenericCar)) {
            return false;
        }
        EntityGenericCar car = (EntityGenericCar)this;
        return car.getPartByClass(PartLicensePlateHolder.class) != null;
    }

    public String getLicensePlate() {
        return (String)this.field_70180_af.func_187225_a(LICENSE_PLATE);
    }

    public void setLicensePlate(String plate) {
        this.field_70180_af.func_187227_b(LICENSE_PLATE, (Object)plate);
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("license_plate", this.getLicensePlate());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setLicensePlate(compound.func_74779_i("license_plate"));
    }

    public abstract Vec3d getLicensePlateOffset();
}

