/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarInventoryBase;
import de.maxhenkel.car.items.ItemKey;
import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.UUID;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class EntityCarLockBase
extends EntityCarInventoryBase {
    private static final DataParameter<Boolean> LOCKED = EntityDataManager.func_187226_a(EntityCarInventoryBase.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityCarLockBase(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public boolean canPlayerEnterCar(PlayerEntity player) {
        if (this.isLocked()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.car_locked", new Object[0]), true);
            return false;
        }
        return super.canPlayerEnterCar(player);
    }

    @Override
    public void destroyCar(PlayerEntity player, boolean dropParts) {
        if (this.isLocked() && !player.func_211513_k(2)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.car_locked", new Object[0]), true);
            return;
        }
        super.destroyCar(player, dropParts);
    }

    @Override
    public boolean canPlayerAccessInventoryExternal(PlayerEntity player) {
        if (this.isLocked()) {
            return false;
        }
        return super.canPlayerAccessInventoryExternal(player);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOCKED, (Object)false);
    }

    public void setLocked(boolean locked, boolean playsound) {
        if (locked && playsound) {
            this.playLockSound();
        } else if (!locked && playsound) {
            this.playUnLockSound();
        }
        this.field_70180_af.func_187227_b(LOCKED, (Object)locked);
    }

    public boolean isLocked() {
        return (Boolean)this.field_70180_af.func_187225_a(LOCKED);
    }

    public void playLockSound() {
        ModSounds.playSound(this.getLockSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.MASTER, 1.0f);
    }

    public void playUnLockSound() {
        ModSounds.playSound(this.getUnLockSound(), this.field_70170_p, this.func_180425_c(), null, SoundCategory.MASTER, 1.0f);
    }

    public SoundEvent getLockSound() {
        return ModSounds.CAR_LOCK;
    }

    public SoundEvent getUnLockSound() {
        return ModSounds.CAR_UNLOCK;
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("locked", this.isLocked());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setLocked(compound.func_74767_n("locked"), false);
    }

    @Override
    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        UUID uuid;
        ItemStack stack = player.func_184586_b(hand);
        if (!this.isLocked() && player.func_225608_bj_() && player.field_71075_bZ.field_75098_d && !stack.func_190926_b() && stack.func_77973_b().equals((Object)ModItems.KEY) && (uuid = ItemKey.getCar(stack)) == null) {
            ItemKey.setCar(stack, this.func_110124_au());
            return true;
        }
        return super.func_184230_a(player, hand);
    }
}

