/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.tools.MathTools;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;

public abstract class EntityCarTemperatureBase
extends EntityCarBase {
    private static final DataParameter<Float> TEMPERATURE = EntityDataManager.func_187226_a(EntityCarTemperatureBase.class, (IDataSerializer)DataSerializers.field_187193_c);

    public EntityCarTemperatureBase(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public void func_70071_h_() {
        float tempToReach;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % 20 != 0) {
            return;
        }
        float speedPerc = this.getSpeed() / this.getMaxSpeed();
        int tempRate = (int)(speedPerc * 10.0f) + 1;
        if (tempRate > 5) {
            tempRate = 5;
        }
        float rate = (float)tempRate * 0.2f + (this.field_70146_Z.nextFloat() - 0.5f) * 0.1f;
        float temp = this.getTemperature();
        if (MathTools.isInBounds(temp, tempToReach = this.getTemperatureToReach(), rate)) {
            this.setTemperature(tempToReach);
        } else {
            if (tempToReach < temp) {
                rate = -rate;
            }
            this.setTemperature(temp + rate);
        }
    }

    public float getTemperatureToReach() {
        float biomeTemp = this.getBiomeTemperatureCelsius();
        if (!this.isStarted()) {
            return biomeTemp;
        }
        float optimalTemp = this.getOptimalTemperature();
        if (biomeTemp > 45.0f) {
            optimalTemp = 100.0f;
        } else if (biomeTemp <= 0.0f) {
            optimalTemp = 80.0f;
        }
        return Math.max(biomeTemp, optimalTemp);
    }

    public float getBiomeTemperatureCelsius() {
        return (this.field_70170_p.func_226691_t_(this.func_180425_c()).func_225486_c(this.func_180425_c()) - 0.3f) * 30.0f;
    }

    public float getTemperature() {
        return ((Float)this.field_70180_af.func_187225_a(TEMPERATURE)).floatValue();
    }

    public void setTemperature(float temperature) {
        this.field_70180_af.func_187227_b(TEMPERATURE, (Object)Float.valueOf(temperature));
    }

    public abstract float getOptimalTemperature();

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TEMPERATURE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setTemperature(compound.func_74760_g("temperature"));
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("temperature", this.getTemperature());
    }

    public void initTemperature() {
        this.setTemperature(this.getBiomeTemperatureCelsius());
    }
}

