/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.parts;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.entity.car.parts.Part;
import de.maxhenkel.car.entity.car.parts.PartBody;
import de.maxhenkel.car.entity.car.parts.PartTransporterBack;
import de.maxhenkel.car.entity.model.obj.OBJModel;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PartBodyTransporter
extends PartBody {
    public PartBodyTransporter(ResourceLocation texture) {
        super(new OBJModel(new ResourceLocation("car", "models/entity/transporter_body.obj")), texture, new Vec3d(0.0, 0.25, 0.0));
        this.wheelOffsets = new Vec3d[]{new Vec3d(0.90625, 0.25, 0.75), new Vec3d(0.90625, 0.25, -1.0), new Vec3d(-0.90625, 0.25, 0.75), new Vec3d(-0.90625, 0.25, -1.0), new Vec3d(0.90625, 0.25, 0.1875), new Vec3d(-0.90625, 0.25, 0.1875)};
        this.playerOffsets = new Vec3d[]{new Vec3d(0.55, -0.378, -0.38), new Vec3d(0.55, -0.378, 0.38)};
        this.numberPlateOffset = new Vec3d(0.0, 0.4375, 1.09375);
        this.width = 2.0f;
        this.height = 1.51f;
        this.minRotationSpeed = 2.0f;
        this.maxRotationSpeed = 5.0f;
        this.fuelEfficiency = () -> ((Double)Config.bodyTransporterFuelEfficiency.get()).floatValue();
        this.acceleration = () -> ((Double)Config.bodyTransporterAcceleration.get()).floatValue();
        this.maxSpeed = () -> ((Double)Config.bodyTransporterMaxSpeed.get()).floatValue();
    }

    @Override
    public boolean validate(List<Part> parts, List<ITextComponent> messages) {
        if (PartBodyTransporter.getAmount(parts, part -> part instanceof PartTransporterBack) > 1) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.too_many_containers", new Object[0]));
            return false;
        }
        return super.validate(parts, messages);
    }
}

