/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.parts;

import de.maxhenkel.car.entity.car.parts.Part;
import de.maxhenkel.car.entity.car.parts.PartTank;
import de.maxhenkel.tools.FloatSupplier;
import java.util.List;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class PartEngine
extends Part {
    protected FloatSupplier maxSpeed;
    protected FloatSupplier maxReverseSpeed;
    protected FloatSupplier acceleration;
    protected FloatSupplier fuelEfficiency;

    public abstract SoundEvent getStopSound();

    public abstract SoundEvent getFailSound();

    public abstract SoundEvent getCrashSound();

    public abstract SoundEvent getStartSound();

    public abstract SoundEvent getStartingSound();

    public abstract SoundEvent getIdleSound();

    public abstract SoundEvent getHighSound();

    public abstract SoundEvent getHornSound();

    public float getMaxSpeed() {
        return this.maxSpeed.getAsFloat();
    }

    public float getMaxReverseSpeed() {
        return this.maxReverseSpeed.getAsFloat();
    }

    public float getAcceleration() {
        return this.acceleration.getAsFloat();
    }

    public float getFuelEfficiency() {
        return this.fuelEfficiency.getAsFloat();
    }

    @Override
    public boolean validate(List<Part> parts, List<ITextComponent> messages) {
        if (PartEngine.getAmount(parts, part -> part instanceof PartTank) > 1) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.too_many_tanks", new Object[0]));
        } else if (PartEngine.getAmount(parts, part -> part instanceof PartTank) <= 0) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.no_tank", new Object[0]));
        }
        return super.validate(parts, messages);
    }
}

