/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityCarFuelBase;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import de.maxhenkel.tools.MathTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent evt) {
        if (!evt.getType().equals((Object)RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        Entity e = player.func_184187_bx();
        if (e == null) {
            return;
        }
        if (!(e instanceof EntityCarFuelBase)) {
            return;
        }
        EntityCarFuelBase car = (EntityCarFuelBase)e;
        if (player.equals((Object)car.getDriver())) {
            evt.setCanceled(true);
            this.renderFuelBar((float)car.getFuelAmount() / (float)car.getMaxFuel());
            this.renderSpeed(car.getKilometerPerHour());
        }
    }

    public void renderFuelBar(float percent) {
        percent = MathHelper.func_76131_a((float)percent, (float)0.0f, (float)1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        int x = mc.func_228018_at_().func_198107_o() / 2 - 91;
        mc.func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
        int k = mc.func_228018_at_().func_198087_p() - 32 + 3;
        mc.field_71456_v.blit(x, k, 0, 64, 182, 5);
        int j = (int)(percent * 182.0f);
        if (j > 0) {
            mc.field_71456_v.blit(x, k, 0, 69, j, 5);
        }
    }

    public void renderSpeed(float speed) {
        Minecraft mc = Minecraft.func_71410_x();
        String s = String.valueOf(MathTools.round(Math.abs(speed), 2));
        int i1 = (mc.func_228018_at_().func_198107_o() - mc.field_71456_v.func_175179_f().func_78256_a(s)) / 2;
        int j1 = mc.func_228018_at_().func_198087_p() - 31 - 4;
        mc.field_71456_v.func_175179_f().func_211126_b(s, (float)(i1 + 1), (float)j1, 0);
        mc.field_71456_v.func_175179_f().func_211126_b(s, (float)(i1 - 1), (float)j1, 0);
        mc.field_71456_v.func_175179_f().func_211126_b(s, (float)i1, (float)(j1 + 1), 0);
        mc.field_71456_v.func_175179_f().func_211126_b(s, (float)i1, (float)(j1 - 1), 0);
        mc.field_71456_v.func_175179_f().func_211126_b(s, (float)i1, (float)j1, 8453920);
    }

    @SubscribeEvent
    public void renderToolTip(RenderTooltipEvent.Pre event) {
        ItemStack stack = event.getStack();
        if (!stack.func_77942_o()) {
            return;
        }
        CompoundNBT compound = stack.func_77978_p();
        if (!compound.func_74764_b("trading_item") && !compound.func_74767_n("trading_item")) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_184187_bx() instanceof EntityCarBase) {
            EntityCarBase car = (EntityCarBase)event.getPlayer().func_184187_bx();
            event.getMatrixStack().func_227860_a_();
            event.getMatrixStack().func_227862_a_(EntityVehicleBase.SCALE_FACTOR, EntityVehicleBase.SCALE_FACTOR, EntityVehicleBase.SCALE_FACTOR);
            event.getMatrixStack().func_227861_a_(0.0, (double)(event.getPlayer().func_213302_cg() - event.getPlayer().func_213302_cg() * EntityVehicleBase.SCALE_FACTOR) / 1.5 + car.getPlayerYOffset(), 0.0);
        }
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        if (event.getPlayer().func_184187_bx() instanceof EntityCarBase) {
            event.getMatrixStack().func_227865_b_();
        }
    }
}

