/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.entity.car.base.EntityCarInventoryBase;
import de.maxhenkel.car.gui.ContainerCar;
import de.maxhenkel.car.gui.GuiBase;
import de.maxhenkel.tools.MathTools;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiCar
extends GuiBase<ContainerCar> {
    private static final ResourceLocation CAR_GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_car.png");
    private static final int fontColor = 0x404040;
    private PlayerInventory playerInv;
    private EntityCarInventoryBase car;

    public GuiCar(ContainerCar containerCar, PlayerInventory playerInv, ITextComponent title) {
        super(CAR_GUI_TEXTURE, containerCar, playerInv, title);
        this.playerInv = playerInv;
        this.car = containerCar.getCar();
        this.field_146999_f = 176;
        this.field_147000_g = 248;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.font.func_211126_b(this.car.func_145748_c_().func_150254_d(), 7.0f, 87.0f, 0x404040);
        this.font.func_211126_b(this.playerInv.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.font.func_211126_b(this.getFuelString(), 7.0f, 9.0f, 0x404040);
        this.font.func_211126_b(this.getDamageString(), 7.0f, 35.0f, 0x404040);
        this.font.func_211126_b(this.getBatteryString(), 95.0f, 9.0f, 0x404040);
        this.font.func_211126_b(this.getTempString(), 95.0f, 35.0f, 0x404040);
    }

    public float getFuelPercent() {
        float fuelPerc = (float)this.car.getFuelAmount() / (float)this.car.getMaxFuel() * 100.0f;
        return MathTools.round(fuelPerc, 2);
    }

    public int getBatteryPercent() {
        return (int)(this.car.getBatteryPercentage() * 100.0f);
    }

    public float getTemperatureCelsius() {
        return MathTools.round(this.car.getTemperature(), 2);
    }

    public float getTemperatureFarenheit() {
        return MathTools.round(this.car.getTemperature() * 1.8f + 32.0f, 2);
    }

    public float getTemperaturePercent() {
        float temp = this.car.getTemperature();
        if (temp > 100.0f) {
            temp = 100.0f;
        }
        if (temp < 0.0f) {
            temp = 0.0f;
        }
        return temp / 100.0f;
    }

    public float getDamagePercent() {
        float dmg = this.car.getDamage();
        dmg = Math.min(dmg, 100.0f);
        return MathTools.round(dmg, 2);
    }

    public String getFuelString() {
        return new TranslationTextComponent("gui.car_fuel", new Object[]{String.valueOf(this.getFuelPercent())}).func_150254_d();
    }

    public String getDamageString() {
        return new TranslationTextComponent("gui.car_damage", new Object[]{String.valueOf(this.getDamagePercent())}).func_150254_d();
    }

    public String getBatteryString() {
        return new TranslationTextComponent("gui.car_battery", new Object[]{String.valueOf(this.getBatteryPercent())}).func_150254_d();
    }

    public String getTempString() {
        if (((Boolean)Config.tempInFarenheit.get()).booleanValue()) {
            return new TranslationTextComponent("gui.car_temperature_farenheit", new Object[]{String.valueOf(this.getTemperatureFarenheit())}).func_150254_d();
        }
        return new TranslationTextComponent("gui.car_temperature_celsius", new Object[]{String.valueOf(this.getTemperatureCelsius())}).func_150254_d();
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.drawFuel(this.getFuelPercent());
        this.drawDamage(100.0f - this.getDamagePercent());
        this.drawBattery(this.car.getBatteryPercentage());
        this.drawTemp(this.getTemperaturePercent());
    }

    public void drawFuel(float percent) {
        int scaled = (int)((double)(72.0f * percent) / 100.0);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + 8, j + 20, 176, 0, scaled, 10);
    }

    public void drawDamage(float percent) {
        int scaled = (int)((double)(72.0f * percent) / 100.0);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + 8, j + 46, 176, 10, scaled, 10);
    }

    public void drawTemp(float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + 96, j + 46, 176, 30, scaled, 10);
    }

    public void drawBattery(float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + 96, j + 20, 176, 20, scaled, 10);
    }
}

