/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.gui.ContainerCarWorkshopCrafting;
import de.maxhenkel.car.gui.GuiBase;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessageSpawnCar;
import de.maxhenkel.tools.EntityTools;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiCarWorkshopCrafting
extends GuiBase<ContainerCarWorkshopCrafting> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_car_workshop_crafting.png");
    private static final int fontColor = 0x404040;
    private TileEntityCarWorkshop tile;
    private PlayerEntity player;
    private Button buttonSpawn;
    private Button buttonRepair;
    private EntityTools.CarRenderer carRenderer;

    public GuiCarWorkshopCrafting(ContainerCarWorkshopCrafting container, PlayerInventory playerInventory, ITextComponent title) {
        super(GUI_TEXTURE, container, playerInventory, title);
        this.player = playerInventory.field_70458_d;
        this.tile = container.getTile();
        this.carRenderer = new EntityTools.CarRenderer();
        this.field_146999_f = 176;
        this.field_147000_g = 222;
    }

    protected void init() {
        super.init();
        this.buttonRepair = (Button)this.addButton((Widget)new Button(this.field_147003_i + 105, this.field_147009_r + 72, 60, 20, new TranslationTextComponent("button.repair_car", new Object[0]).func_150254_d(), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenCarWorkshopGui(this.tile.func_174877_v(), this.player, true))));
        this.buttonSpawn = (Button)this.addButton((Widget)new Button(this.field_147003_i + 105, this.field_147009_r + 106, 60, 20, new TranslationTextComponent("button.spawn_car", new Object[0]).func_150254_d(), button -> {
            if (this.tile.func_145831_w().field_72995_K) {
                if (this.tile.isCurrentCraftingCarValid()) {
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSpawnCar(this.tile.func_174877_v()));
                } else {
                    for (ITextComponent message : this.tile.getMessages()) {
                        this.field_213127_e.field_70458_d.func_145747_a(message);
                    }
                }
            }
        }));
        this.buttonSpawn.active = false;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.font.func_211126_b(this.tile.func_145748_c_().func_150254_d(), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EntityCarBase carTop = this.tile.getCarOnTop();
        EntityGenericCar car = this.tile.getCurrentCraftingCar();
        if (carTop != null) {
            this.drawCar(carTop);
            this.buttonSpawn.active = false;
        } else {
            if (car != null) {
                this.drawCar(car);
            }
            this.buttonSpawn.active = true;
        }
    }

    public void tick() {
        super.tick();
        this.carRenderer.tick();
    }

    private void drawCar(EntityCarBase car) {
        this.carRenderer.render(car, this.field_146999_f / 2, 55, 23);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

