/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.gui.ContainerCarWorkshopRepair;
import de.maxhenkel.car.gui.GuiBase;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessageRepairCar;
import de.maxhenkel.tools.EntityTools;
import de.maxhenkel.tools.MathTools;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiCarWorkshopRepair
extends GuiBase<ContainerCarWorkshopRepair> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_car_workshop_repair.png");
    private static final int fontColor = 0x404040;
    private PlayerEntity player;
    private TileEntityCarWorkshop tile;
    private Button buttonBack;
    private Button buttonRepair;
    private EntityTools.CarRenderer carRenderer;

    public GuiCarWorkshopRepair(ContainerCarWorkshopRepair container, PlayerInventory playerInventory, ITextComponent title) {
        super(GUI_TEXTURE, container, playerInventory, title);
        this.player = container.getPlayer();
        this.tile = container.getTile();
        this.carRenderer = new EntityTools.CarRenderer();
        this.field_146999_f = 176;
        this.field_147000_g = 222;
    }

    protected void init() {
        super.init();
        this.buttonRepair = (Button)this.addButton((Widget)new Button(this.field_147003_i + this.field_146999_f - 7 - 60, this.field_147009_r + 105, 60, 20, new TranslationTextComponent("button.repair_car", new Object[0]).func_150254_d(), button -> {
            if (this.tile.func_145831_w().field_72995_K) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRepairCar(this.tile.func_174877_v(), this.player));
            }
        }));
        this.buttonRepair.active = false;
        this.buttonBack = (Button)this.addButton((Widget)new Button(this.field_147003_i + 7, this.field_147009_r + 105, 60, 20, new TranslationTextComponent("button.back", new Object[0]).func_150254_d(), button -> {
            if (this.tile.func_145831_w().field_72995_K) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenCarWorkshopGui(this.tile.func_174877_v(), this.player, false));
            }
        }));
        this.buttonBack.active = true;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.font.func_211126_b(this.tile.func_145748_c_().func_150254_d(), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.player.field_71071_by.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        EntityCarBase carTop = this.tile.getCarOnTop();
        if (!(carTop instanceof EntityCarDamageBase)) {
            this.buttonRepair.active = false;
            return;
        }
        EntityCarDamageBase car = (EntityCarDamageBase)carTop;
        if (mouseX >= this.field_147003_i + 52 && mouseX <= this.field_147003_i + 123 && mouseY >= this.field_147009_r + 81 && mouseY <= this.field_147009_r + 90) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(new TranslationTextComponent("tooltip.damage", new Object[]{Float.valueOf(MathTools.round(car.getDamage(), 2))}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        this.buttonRepair.active = this.tile.areRepairItemsInside() && car.getDamage() > 0.0f;
        this.drawCar(carTop);
    }

    public void tick() {
        super.tick();
        this.carRenderer.tick();
    }

    private void drawCar(EntityCarBase car) {
        this.carRenderer.render(car, this.field_146999_f / 2, 55, 23);
    }

    public double getDamagePercent(EntityCarDamageBase car) {
        float dmg = car.getDamage();
        dmg = Math.min(dmg, 100.0f);
        return MathTools.round(dmg, 2);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.drawDamage();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void drawDamage() {
        EntityCarBase car = this.tile.getCarOnTop();
        if (!(car instanceof EntityCarDamageBase)) {
            return;
        }
        EntityCarDamageBase c = (EntityCarDamageBase)car;
        double percent = 100.0 - this.getDamagePercent(c);
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        int scaled = (int)(72.0 * percent / 100.0);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + 52, j + 81, 176, 0, scaled, 10);
    }
}

