/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityEnergyFluidProducer;
import de.maxhenkel.car.gui.ContainerEnergyFluidProducer;
import de.maxhenkel.car.gui.GuiBase;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GuiEnergyFluidProducer<T extends ContainerEnergyFluidProducer>
extends GuiBase<T> {
    private static final int fontColor = 0x404040;
    private PlayerInventory playerInv;
    private TileEntityEnergyFluidProducer tile;

    public GuiEnergyFluidProducer(ResourceLocation texture, T container, PlayerInventory playerInventory, ITextComponent title) {
        super(texture, container, playerInventory, title);
        this.playerInv = playerInventory;
        this.tile = ((ContainerEnergyFluidProducer)((Object)container)).getTile();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public String getUnlocalizedTooltipEnergy() {
        return "tooltip.energy";
    }

    public String getUnlocalizedTooltipProgress() {
        return "tooltip.progress";
    }

    public abstract String getUnlocalizedTooltipLiquid();

    protected void func_146979_b(int mouseX, int mouseY) {
        ArrayList<String> list;
        super.func_146979_b(mouseX, mouseY);
        this.font.func_211126_b(this.getTitle().func_150254_d(), 38.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.playerInv.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        if (mouseX >= this.field_147003_i + 11 && mouseX <= this.field_147003_i + 16 + 11 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList<String>();
            list.add(new TranslationTextComponent(this.getUnlocalizedTooltipEnergy(), new Object[]{this.tile.getStoredEnergy()}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 148 && mouseX <= this.field_147003_i + 16 + 148 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TranslationTextComponent(this.getUnlocalizedTooltipLiquid(), new Object[]{this.tile.getCurrentMillibuckets()}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 79 && mouseX <= this.field_147003_i + 24 + 79 && mouseY >= this.field_147009_r + 34 && mouseY <= this.field_147009_r + 17 + 34) {
            list = new ArrayList();
            list.add(new TranslationTextComponent(this.getUnlocalizedTooltipProgress(), new Object[]{(int)(this.getProgress() * 100.0f)}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    public void drawEnergy() {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 11;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawFluid() {
        float perc = this.getFluid();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 148;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawProgress() {
        float perc = this.getProgress();
        int texX = 176;
        int texY = 0;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + targetX, j + targetY, texX, texY, scWidth, texH);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.getMaxEnergy();
    }

    public float getFluid() {
        return (float)this.tile.getCurrentMillibuckets() / (float)this.tile.getFluidAmount();
    }

    public float getProgress() {
        if (this.tile.getTimeToGenerate() == 0) {
            return 0.0f;
        }
        return (float)this.tile.getGeneratingTime() / (float)this.tile.getTimeToGenerate();
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.drawEnergy();
        this.drawFluid();
        this.drawProgress();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

