/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.gui.ContainerGasStation;
import de.maxhenkel.car.gui.GuiBase;
import de.maxhenkel.tools.FluidUtils;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class GuiGasStation
extends GuiBase<ContainerGasStation> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_gas_station.png");
    private TileEntityGasStation gasStation;
    private PlayerInventory playerInventory;
    private static final int TITLE_COLOR = Color.WHITE.getRGB();
    private static final int FONT_COLOR = Color.DARK_GRAY.getRGB();
    protected Button buttonStart;
    protected Button buttonStop;

    public GuiGasStation(ContainerGasStation gasStation, PlayerInventory playerInventory, ITextComponent title) {
        super(GUI_TEXTURE, gasStation, playerInventory, title);
        this.gasStation = gasStation.getGasStation();
        this.playerInventory = playerInventory;
        this.field_146999_f = 176;
        this.field_147000_g = 217;
    }

    protected void init() {
        super.init();
        this.buttonStart = (Button)this.addButton((Widget)new Button(this.width / 2 - 20, this.field_147009_r + 100, 40, 20, new TranslationTextComponent("button.start", new Object[0]).func_150254_d(), button -> {
            this.gasStation.setFueling(true);
            this.gasStation.sendStartFuelPacket(true);
        }));
        this.buttonStop = (Button)this.addButton((Widget)new Button(this.field_147003_i + this.field_146999_f - 40 - 7, this.field_147009_r + 100, 40, 20, new TranslationTextComponent("button.stop", new Object[0]).func_150254_d(), button -> {
            this.gasStation.setFueling(false);
            this.gasStation.sendStartFuelPacket(false);
        }));
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.buttonStart.active = !this.gasStation.isFueling();
        this.buttonStop.active = this.gasStation.isFueling();
        this.drawCenteredString(this.font, new TranslationTextComponent("gui.gas_station", new Object[0]).func_150254_d(), this.width / 2, this.field_147009_r + 5, TITLE_COLOR);
        IFluidHandler fluidHandler = this.gasStation.getFluidHandlerInFront();
        if (fluidHandler instanceof Entity) {
            this.drawCarName((Entity)fluidHandler);
        }
        this.drawCarFuel(fluidHandler);
        this.drawRefueled();
        this.drawBuffer();
        this.font.func_211126_b(this.playerInventory.func_145748_c_().func_150254_d(), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + this.field_147000_g - 93), FONT_COLOR);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        ItemStack stack = this.gasStation.getTradingInventory().func_70301_a(0);
        if (stack.func_190926_b()) {
            return;
        }
        if (mouseX >= this.field_147003_i + 18 && mouseX <= this.field_147003_i + 33 && mouseY >= this.field_147009_r + 99 && mouseY <= this.field_147009_r + 114) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(new TranslationTextComponent("tooltip.trade", new Object[]{stack.func_190916_E(), stack.func_200301_q(), this.gasStation.getTradeAmount()}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    private void drawCarName(Entity entity) {
        String carText = entity == null ? new TranslationTextComponent("gas_station.nocar", new Object[0]).func_150254_d() : new TranslationTextComponent("gas_station.carinfo", new Object[]{entity.func_145748_c_().func_211708_a(TextFormatting.WHITE)}).func_150254_d();
        this.font.func_211126_b(carText, (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 20), FONT_COLOR);
    }

    private void drawCarFuel(IFluidHandler handler) {
        if (handler == null || handler.getTanks() < 1) {
            String empty = new TranslationTextComponent("gas_station.fuel_empty", new Object[0]).func_150254_d();
            this.font.func_211126_b(empty, (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 30), FONT_COLOR);
            return;
        }
        FluidStack tank = handler.getFluidInTank(0);
        String fuelText = new TranslationTextComponent("gas_station.car_fuel_amount", new Object[]{new StringTextComponent(String.valueOf(tank.getAmount())).func_211708_a(TextFormatting.WHITE), new StringTextComponent(String.valueOf(handler.getTankCapacity(0))).func_211708_a(TextFormatting.WHITE)}).func_150254_d();
        this.font.func_211126_b(fuelText, (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 30), FONT_COLOR);
        if (FluidUtils.isEmpty(tank)) {
            return;
        }
        String typeText = new TranslationTextComponent("gas_station.car_fuel_type", new Object[]{tank.getDisplayName().func_211708_a(TextFormatting.WHITE)}).func_150254_d();
        this.font.func_211126_b(typeText, (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 40), FONT_COLOR);
    }

    private void drawRefueled() {
        String refueledText = new TranslationTextComponent("gas_station.refueled", new Object[]{new StringTextComponent(String.valueOf(this.gasStation.getFuelCounter())).func_211708_a(TextFormatting.WHITE)}).func_150254_d();
        this.font.func_211126_b(refueledText, (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 60), FONT_COLOR);
    }

    private void drawBuffer() {
        FluidStack stack = this.gasStation.getStorage();
        if (FluidUtils.isEmpty(stack)) {
            String bufferText = new TranslationTextComponent("gas_station.fuel_empty", new Object[0]).func_150254_d();
            this.font.func_211126_b(bufferText, (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 70), FONT_COLOR);
            return;
        }
        int amount = this.gasStation.getFuelAmount();
        String amountText = new TranslationTextComponent("gas_station.fuel_buffer_amount", new Object[]{new StringTextComponent(String.valueOf(amount)).func_211708_a(TextFormatting.WHITE), new StringTextComponent(String.valueOf(this.gasStation.maxStorageAmount)).func_211708_a(TextFormatting.WHITE)}).func_150254_d();
        this.font.func_211126_b(amountText, (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 70), FONT_COLOR);
        String bufferText = new TranslationTextComponent("gas_station.fuel_buffer_type", new Object[]{stack.getDisplayName().func_211708_a(TextFormatting.WHITE)}).func_150254_d();
        this.font.func_211126_b(bufferText, (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 80), FONT_COLOR);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

