/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntityGenerator;
import de.maxhenkel.car.gui.ContainerGenerator;
import de.maxhenkel.car.gui.GuiBase;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiGenerator
extends GuiBase<ContainerGenerator> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_generator.png");
    private static final int fontColor = 0x404040;
    private PlayerInventory playerInv;
    private TileEntityGenerator tile;

    public GuiGenerator(ContainerGenerator containerGenerator, PlayerInventory playerInv, ITextComponent title) {
        super(GUI_TEXTURE, containerGenerator, playerInv, title);
        this.playerInv = playerInv;
        this.tile = containerGenerator.getGenerator();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        ArrayList<String> list;
        super.func_146979_b(mouseX, mouseY);
        this.font.func_211126_b(this.playerInv.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.font.func_211126_b(this.tile.func_145748_c_().func_150254_d(), 62.0f, 6.0f, 0x404040);
        if (mouseX >= this.field_147003_i + 122 && mouseX <= this.field_147003_i + 16 + 122 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList<String>();
            list.add(new TranslationTextComponent("tooltip.energy", new Object[]{this.tile.getStoredEnergy()}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (mouseX >= this.field_147003_i + 39 && mouseX <= this.field_147003_i + 16 + 39 && mouseY >= this.field_147009_r + 8 && mouseY <= this.field_147009_r + 57 + 8) {
            list = new ArrayList();
            list.add(new TranslationTextComponent("tooltip.fuel", new Object[]{this.tile.getCurrentMillibuckets()}).func_150254_d());
            this.renderTooltip(list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.drawEnergy();
        this.drawFluid();
    }

    public void drawEnergy() {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 122;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawFluid() {
        float perc = this.getFluid();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 39;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.blit(i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.maxStorage;
    }

    public float getFluid() {
        return (float)this.tile.getCurrentMillibuckets() / (float)this.tile.maxMillibuckets;
    }
}

