/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.jei;

import de.maxhenkel.car.blocks.BlockPaint;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.integration.jei.CarRecipeBuilder;
import de.maxhenkel.car.integration.jei.CarRecipeCategory;
import de.maxhenkel.car.integration.jei.PainterRecipe;
import de.maxhenkel.car.integration.jei.PainterRecipeCategory;
import de.maxhenkel.car.integration.jei.PainterRecipeCategoryYellow;
import de.maxhenkel.car.items.ModItems;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation CATEGORY_CAR_WORKSHOP = new ResourceLocation("car", "car_workshop");
    public static final ResourceLocation CATEGORY_PAINTER = new ResourceLocation("car", "painter");
    public static final ResourceLocation CATEGORY_PAINTER_YELLOW = new ResourceLocation("car", "painter_yellow");

    public void onRuntimeAvailable(IJeiRuntime runtime) {
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.PAINTER), new ResourceLocation[]{CATEGORY_PAINTER});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.PAINTER_YELLOW), new ResourceLocation[]{CATEGORY_PAINTER_YELLOW});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CAR_WORKSHOP), new ResourceLocation[]{CATEGORY_CAR_WORKSHOP});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes((Collection)Arrays.stream(ModBlocks.PAINTS).map(paint -> new PainterRecipe(ModItems.PAINTER, (BlockPaint)paint)).collect(Collectors.toList()), CATEGORY_PAINTER);
        registration.addRecipes((Collection)Arrays.stream(ModBlocks.YELLOW_PAINTS).map(paint -> new PainterRecipe(ModItems.PAINTER_YELLOW, (BlockPaint)paint)).collect(Collectors.toList()), CATEGORY_PAINTER_YELLOW);
        registration.addRecipes(CarRecipeBuilder.getAllRecipes(), CATEGORY_CAR_WORKSHOP);
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.PAINTER), VanillaTypes.ITEM, new String[]{"description.painter_white"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.PAINTER_YELLOW), VanillaTypes.ITEM, new String[]{"description.painter_yellow"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.CANISTER), VanillaTypes.ITEM, new String[]{"description.canister"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.REPAIR_KIT), VanillaTypes.ITEM, new String[]{"description.repair_kit"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModBlocks.CRANK), VanillaTypes.ITEM, new String[]{"description.crank"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModBlocks.DYNAMO), VanillaTypes.ITEM, new String[]{"description.dynamo"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModBlocks.FUEL_STATION), VanillaTypes.ITEM, new String[]{"description.fuel_station"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModBlocks.FUEL_STATION), VanillaTypes.ITEM, new String[]{"description.fuel_station_admin"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModBlocks.TANK), VanillaTypes.ITEM, new String[]{"description.tank"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModBlocks.FLUID_EXTRACTOR), VanillaTypes.ITEM, new String[]{"description.fluid_extractor"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.BATTERY), VanillaTypes.ITEM, new String[]{"description.battery"});
        registration.addIngredientInfo(Arrays.stream(ModItems.CONTAINERS).map(item -> new ItemStack((IItemProvider)item)).collect(Collectors.toList()), VanillaTypes.ITEM, new String[]{"description.container"});
        registration.addIngredientInfo(Arrays.stream(ModItems.TANK_CONTAINERS).map(item -> new ItemStack((IItemProvider)item)).collect(Collectors.toList()), VanillaTypes.ITEM, new String[]{"description.tank_container"});
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModItems.LICENSE_PLATE), VanillaTypes.ITEM, new String[]{"description.license_plate"});
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("car", "car");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new PainterRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PainterRecipeCategoryYellow(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CarRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }
}

