/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.waila;

import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.integration.waila.PluginCar;
import de.maxhenkel.tools.MathTools;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class HUDHandlerCars
implements IEntityComponentProvider {
    static final HUDHandlerCars INSTANCE = new HUDHandlerCars();

    public void appendHead(List<ITextComponent> tip, IEntityAccessor accessor, IPluginConfig config) {
        ITaggableList tooltip = (ITaggableList)tip;
        tooltip.setTag((Object)PluginCar.OBJECT_NAME_TAG, (Object)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getEntityName(), accessor.getEntity().func_145748_c_().func_150254_d())));
        if (config.get(PluginCar.CONFIG_SHOW_REGISTRY)) {
            tooltip.setTag((Object)PluginCar.REGISTRY_NAME_TAG, (Object)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getRegistryName(), accessor.getEntity().func_200600_R().getRegistryName().toString())));
        }
    }

    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        float damage;
        if (!(accessor.getEntity() instanceof EntityGenericCar)) {
            return;
        }
        EntityGenericCar car = (EntityGenericCar)accessor.getEntity();
        FluidStack carFluid = car.getFluidInTank(0);
        if (!carFluid.isEmpty()) {
            TranslationTextComponent fluid = new TranslationTextComponent("tooltip.waila.car.fuel", new Object[]{carFluid.getDisplayName()});
            TranslationTextComponent amount = new TranslationTextComponent("tooltip.waila.car.fuel_amount", new Object[]{carFluid.getAmount(), car.getMaxFuel()});
            tooltip.add((ITextComponent)fluid);
            tooltip.add((ITextComponent)amount);
        }
        if ((damage = car.getDamage()) > 0.0f) {
            TranslationTextComponent dmg = new TranslationTextComponent("tooltip.waila.car.damage", new Object[]{Float.valueOf(MathTools.round(damage, 2))});
            tooltip.add((ITextComponent)dmg);
        }
    }

    public void appendTail(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        tooltip.add((ITextComponent)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getModName(), ModIdentification.getModInfo((Entity)accessor.getEntity()).getName())));
    }
}

