/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tools;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class EntityTools {
    @Nullable
    public static EntityGenericCar getCarByUUID(PlayerEntity player, UUID uuid) {
        double distance = 10.0;
        return player.field_70170_p.func_175647_a(EntityGenericCar.class, new AxisAlignedBB(player.func_226277_ct_() - distance, player.func_226278_cu_() - distance, player.func_226281_cx_() - distance, player.func_226277_ct_() + distance, player.func_226278_cu_() + distance, player.func_226281_cx_() + distance), entity -> entity.func_110124_au().equals(uuid)).stream().findAny().orElse(null);
    }

    public static void drawCarOnScreen(EntityCarBase car, int posX, int posY, int scale, float rotation) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_((float)scale, (float)scale, (float)scale);
        matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(135.0f + rotation));
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        matrixstack.func_227863_a_(quaternion);
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityrenderermanager.func_229084_a_((Entity)car, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)buffer, 0xF000F0);
        buffer.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        RenderSystem.popMatrix();
    }

    public static interface Renderer {
        public void render(float var1);

        public void tick();
    }

    public static class SimulatedTicker {
        private static final long ONE_TICK = 50000000L;
        private long lastTick;

        public void render(Renderer renderer) {
            long currentNanos = System.nanoTime();
            if (currentNanos - this.lastTick >= 50000000L) {
                renderer.tick();
                this.lastTick = currentNanos;
            }
            renderer.render((float)(currentNanos - this.lastTick) / 5.0E7f);
        }
    }

    public static class SimulatedCarRenderer {
        private float rotation;
        private float rotationPerTick;
        private SimulatedTicker ticker;

        public SimulatedCarRenderer(float rotationPerTick) {
            this.rotationPerTick = rotationPerTick;
            this.ticker = new SimulatedTicker();
        }

        public SimulatedCarRenderer() {
            this(3.6f);
        }

        public void render(final EntityCarBase car, final int posX, final int posY, final int scale) {
            this.ticker.render(new Renderer(){

                @Override
                public void render(float partialTicks) {
                    EntityTools.drawCarOnScreen(car, posX, posY, scale, rotation + rotationPerTick * partialTicks);
                }

                @Override
                public void tick() {
                    rotation = rotation + rotationPerTick;
                    if (rotation >= 360.0f) {
                        rotation = 0.0f;
                    }
                }
            });
        }
    }

    public static class CarRenderer {
        private float rotation;
        private float rotationPerTick;
        private Minecraft minecraft;

        public CarRenderer(float rotationPerTick) {
            this.rotationPerTick = rotationPerTick;
            this.minecraft = Minecraft.func_71410_x();
        }

        public CarRenderer() {
            this(3.6f);
        }

        public void tick() {
            this.rotation += this.rotationPerTick;
            if (this.rotation >= 360.0f) {
                this.rotation = 0.0f;
            }
        }

        public void render(EntityCarBase car, int posX, int posY, int scale) {
            EntityTools.drawCarOnScreen(car, posX, posY, scale, this.rotation + this.rotationPerTick * this.minecraft.func_184121_ak());
        }
    }
}

