/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tools;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;

public class ItemTools {
    public static boolean matchesTag(ItemStack stack, ResourceLocation tag) {
        return stack.func_77973_b().getTags().contains(tag);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.func_77973_b() == null || stack2.func_77973_b() == null) {
            return false;
        }
        if (stack1.func_77973_b() == stack2.func_77973_b()) {
            return stack1.func_77952_i() == stack2.func_77952_i();
        }
        return false;
    }

    public static boolean contains(List<ItemStack> list, ItemStack item) {
        return list.stream().anyMatch(stack -> ItemTools.areItemsEqual(stack, item));
    }

    public static ItemStack itemStackAmount(int amount, ItemStack stack, PlayerEntity player) {
        if (stack == null || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return stack;
        }
        stack.func_190920_e(stack.func_190916_E() + amount);
        if (stack.func_190916_E() <= 0) {
            stack.func_190920_e(0);
            return ItemStack.field_190927_a;
        }
        if (stack.func_190916_E() > stack.func_77976_d()) {
            stack.func_190920_e(stack.func_77976_d());
        }
        return stack;
    }

    public static ItemStack decrItemStack(ItemStack stack, PlayerEntity player) {
        return ItemTools.itemStackAmount(-1, stack, player);
    }

    public static ItemStack incrItemStack(ItemStack stack, PlayerEntity player) {
        return ItemTools.itemStackAmount(1, stack, player);
    }

    public static void removeStackFromSlot(IInventory inventory, int index) {
        inventory.func_70299_a(index, ItemStack.field_190927_a);
    }

    public static void saveInventory(CompoundNBT compound, String name, IInventory inv) {
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Slot", i);
            inv.func_70301_a(i).func_77955_b(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        compound.func_218657_a(name, (INBT)nbttaglist);
    }

    public static void readInventory(CompoundNBT compound, String name, IInventory inv) {
        if (!compound.func_74764_b(name)) {
            return;
        }
        ListNBT nbttaglist = compound.func_150295_c(name, 10);
        if (nbttaglist == null) {
            return;
        }
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74762_e("Slot");
            if (j < 0 || j >= inv.func_70302_i_()) continue;
            inv.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)nbttagcompound));
        }
    }
}

