/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.parts;

import de.maxhenkel.car.corelib.client.obj.OBJModel;
import de.maxhenkel.car.entity.car.parts.Part;
import de.maxhenkel.car.entity.car.parts.PartBumper;
import de.maxhenkel.car.entity.car.parts.PartContainer;
import de.maxhenkel.car.entity.car.parts.PartEngine;
import de.maxhenkel.car.entity.car.parts.PartLicensePlateHolder;
import de.maxhenkel.car.entity.car.parts.PartModel;
import de.maxhenkel.car.entity.car.parts.PartWheel;
import de.maxhenkel.car.entity.car.parts.PartWheelBase;
import de.maxhenkel.tools.FloatSupplier;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PartBody
extends PartModel {
    protected Vector3d[] wheelOffsets;
    protected Vector3d[] playerOffsets;
    protected Vector3d numberPlateOffset;
    protected float width;
    protected float height;
    protected float minRotationSpeed;
    protected float maxRotationSpeed;
    protected FloatSupplier fuelEfficiency;
    protected FloatSupplier acceleration;
    protected FloatSupplier maxSpeed;
    protected String translationKey;
    protected String materialTranslationKey;

    public PartBody(OBJModel model, ResourceLocation texture, Vector3d offset, String translationKey, String materialTranslationKey) {
        super(model, texture, offset);
        this.translationKey = translationKey;
        this.materialTranslationKey = materialTranslationKey;
    }

    public Vector3d[] getWheelOffsets() {
        return this.wheelOffsets;
    }

    public Vector3d[] getPlayerOffsets() {
        return this.playerOffsets;
    }

    public Vector3d getNumberPlateOffset() {
        return this.numberPlateOffset;
    }

    public float getMinRotationSpeed() {
        return this.minRotationSpeed;
    }

    public float getMaxRotationSpeed() {
        return this.maxRotationSpeed;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    protected int getWheelAmount() {
        return this.wheelOffsets.length;
    }

    public float getFuelEfficiency() {
        return this.fuelEfficiency.getAsFloat();
    }

    public float getAcceleration() {
        return this.acceleration.getAsFloat();
    }

    public float getMaxSpeed() {
        return this.maxSpeed.getAsFloat();
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public String getMaterialTranslationKey() {
        return this.materialTranslationKey;
    }

    public boolean canFitWheel(PartWheelBase wheel) {
        return wheel instanceof PartWheel;
    }

    @Override
    public boolean validate(List<Part> parts, List<ITextComponent> messages) {
        int wheelAmount = PartBody.getAmount(parts, part -> part instanceof PartWheelBase);
        if (wheelAmount < this.getWheelAmount()) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.too_few_wheels", new Object[]{this.getWheelAmount()}));
        } else if (wheelAmount > this.getWheelAmount()) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.too_many_wheels", new Object[]{this.getWheelAmount()}));
        }
        int engineAmount = PartBody.getAmount(parts, part -> part instanceof PartEngine);
        if (engineAmount <= 0) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.no_engine"));
        } else if (engineAmount > 1) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.too_many_engines"));
        }
        if (PartBody.getAmount(parts, part -> part instanceof PartLicensePlateHolder) > 1) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.too_many_license_plates"));
        }
        if (PartBody.getAmount(parts, part -> part instanceof PartBumper) > 1) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.too_many_bumpers"));
        }
        if (PartBody.getAmount(parts, part -> part instanceof PartContainer) > 1) {
            messages.add((ITextComponent)new TranslationTextComponent("message.parts.too_many_containers"));
        }
        return true;
    }
}

