/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

@OnlyIn(value=Dist.CLIENT)
public class PlayerEvents {
    private Minecraft minecraft = Minecraft.func_71410_x();
    private EntityVehicleBase lastVehicle = null;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side.equals((Object)LogicalSide.SERVER)) {
            return;
        }
        if (!evt.player.equals((Object)this.getPlayer())) {
            return;
        }
        EntityVehicleBase vehicle = this.getRidingVehicle();
        if (vehicle != null && this.lastVehicle == null) {
            if (vehicle.doesEnterThirdPerson()) {
                this.setThirdPerson(true);
            }
        } else if (vehicle == null && this.lastVehicle != null && this.lastVehicle.doesEnterThirdPerson()) {
            this.setThirdPerson(false);
        }
        this.lastVehicle = vehicle;
    }

    private void setThirdPerson(boolean third) {
        if (!((Boolean)Main.CLIENT_CONFIG.thirdPersonEnter.get()).booleanValue()) {
            return;
        }
        this.minecraft.field_71474_y.field_74320_O = third ? 1 : 0;
    }

    private ClientPlayerEntity getPlayer() {
        return this.minecraft.field_71439_g;
    }

    private Entity getRidingEntity() {
        return this.getPlayer().func_184187_bx();
    }

    private EntityVehicleBase getRidingVehicle() {
        Entity e = this.getRidingEntity();
        if (e instanceof EntityVehicleBase) {
            return (EntityVehicleBase)e;
        }
        return null;
    }
}

