/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarInventoryBase;
import de.maxhenkel.car.gui.ContainerCar;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiCar
extends ScreenBase<ContainerCar> {
    private static final ResourceLocation CAR_GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_car.png");
    private static final int fontColor = 0x404040;
    private PlayerInventory playerInv;
    private EntityCarInventoryBase car;

    public GuiCar(ContainerCar containerCar, PlayerInventory playerInv, ITextComponent title) {
        super(CAR_GUI_TEXTURE, containerCar, playerInv, title);
        this.playerInv = playerInv;
        this.car = containerCar.getCar();
        this.field_146999_f = 176;
        this.field_147000_g = 248;
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)this.car.func_145748_c_(), 7.0f, 87.0f, 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)this.playerInv.func_145748_c_(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)this.getFuelString(), 7.0f, 9.0f, 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)this.getDamageString(), 7.0f, 35.0f, 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)this.getBatteryString(), 95.0f, 9.0f, 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)this.getTempString(), 95.0f, 35.0f, 0x404040);
    }

    public float getFuelPercent() {
        float fuelPerc = (float)this.car.getFuelAmount() / (float)this.car.getMaxFuel() * 100.0f;
        return MathUtils.round(fuelPerc, 2);
    }

    public int getBatteryPercent() {
        return (int)(this.car.getBatteryPercentage() * 100.0f);
    }

    public float getTemperatureCelsius() {
        return MathUtils.round(this.car.getTemperature(), 2);
    }

    public float getTemperatureFarenheit() {
        return MathUtils.round(this.car.getTemperature() * 1.8f + 32.0f, 2);
    }

    public float getTemperaturePercent() {
        float temp = this.car.getTemperature();
        if (temp > 100.0f) {
            temp = 100.0f;
        }
        if (temp < 0.0f) {
            temp = 0.0f;
        }
        return temp / 100.0f;
    }

    public float getDamagePercent() {
        float dmg = this.car.getDamage();
        dmg = Math.min(dmg, 100.0f);
        return MathUtils.round(dmg, 2);
    }

    public TextComponent getFuelString() {
        return new TranslationTextComponent("gui.car_fuel", new Object[]{String.valueOf(this.getFuelPercent())});
    }

    public TextComponent getDamageString() {
        return new TranslationTextComponent("gui.car_damage", new Object[]{String.valueOf(this.getDamagePercent())});
    }

    public TextComponent getBatteryString() {
        return new TranslationTextComponent("gui.car_battery", new Object[]{String.valueOf(this.getBatteryPercent())});
    }

    public TextComponent getTempString() {
        if (((Boolean)Main.CLIENT_CONFIG.tempInFarenheit.get()).booleanValue()) {
            return new TranslationTextComponent("gui.car_temperature_farenheit", new Object[]{String.valueOf(this.getTemperatureFarenheit())});
        }
        return new TranslationTextComponent("gui.car_temperature_celsius", new Object[]{String.valueOf(this.getTemperatureCelsius())});
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.drawFuel(matrixStack, this.getFuelPercent());
        this.drawDamage(matrixStack, 100.0f - this.getDamagePercent());
        this.drawBattery(matrixStack, this.car.getBatteryPercentage());
        this.drawTemp(matrixStack, this.getTemperaturePercent());
    }

    public void drawFuel(MatrixStack matrixStack, float percent) {
        int scaled = (int)((double)(72.0f * percent) / 100.0);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i + 8, j + 20, 176, 0, scaled, 10);
    }

    public void drawDamage(MatrixStack matrixStack, float percent) {
        int scaled = (int)((double)(72.0f * percent) / 100.0);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i + 8, j + 46, 176, 10, scaled, 10);
    }

    public void drawTemp(MatrixStack matrixStack, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i + 96, j + 46, 176, 30, scaled, 10);
    }

    public void drawBattery(MatrixStack matrixStack, float percent) {
        int scaled = (int)(72.0f * percent);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i + 96, j + 20, 176, 20, scaled, 10);
    }
}

