/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.gui.ContainerCarWorkshopRepair;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessageRepairCar;
import de.maxhenkel.tools.EntityTools;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiCarWorkshopRepair
extends ScreenBase<ContainerCarWorkshopRepair> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_car_workshop_repair.png");
    private PlayerEntity player;
    private TileEntityCarWorkshop tile;
    private Button buttonBack;
    private Button buttonRepair;
    private EntityTools.CarRenderer carRenderer;

    public GuiCarWorkshopRepair(ContainerCarWorkshopRepair container, PlayerInventory playerInventory, ITextComponent title) {
        super(GUI_TEXTURE, container, playerInventory, title);
        this.player = container.getPlayer();
        this.tile = container.getTile();
        this.carRenderer = new EntityTools.CarRenderer();
        this.field_146999_f = 176;
        this.field_147000_g = 222;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.buttonRepair = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.field_146999_f - 7 - 60, this.field_147009_r + 105, 60, 20, (ITextComponent)new TranslationTextComponent("button.car.repair_car"), button -> {
            if (this.tile.func_145831_w().field_72995_K) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRepairCar(this.tile.func_174877_v(), this.player));
            }
        }));
        this.buttonRepair.field_230693_o_ = false;
        this.buttonBack = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 7, this.field_147009_r + 105, 60, 20, (ITextComponent)new TranslationTextComponent("button.car.back"), button -> {
            if (this.tile.func_145831_w().field_72995_K) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenCarWorkshopGui(this.tile.func_174877_v(), this.player, false));
            }
        }));
        this.buttonBack.field_230693_o_ = true;
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)this.tile.func_145748_c_(), 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)this.player.field_71071_by.func_145748_c_(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        EntityCarBase carTop = this.tile.getCarOnTop();
        if (!(carTop instanceof EntityCarDamageBase)) {
            this.buttonRepair.field_230693_o_ = false;
            return;
        }
        EntityCarDamageBase car = (EntityCarDamageBase)carTop;
        if (mouseX >= this.field_147003_i + 52 && mouseX <= this.field_147003_i + 123 && mouseY >= this.field_147009_r + 81 && mouseY <= this.field_147009_r + 90) {
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            list.add(new TranslationTextComponent("tooltip.damage", new Object[]{Float.valueOf(MathUtils.round(car.getDamage(), 2))}));
            this.func_238654_b_(matrixStack, list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        this.buttonRepair.field_230693_o_ = this.tile.areRepairItemsInside() && car.getDamage() > 0.0f;
        this.drawCar(matrixStack, carTop);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.carRenderer.tick();
    }

    private void drawCar(MatrixStack matrixStack, EntityCarBase car) {
        this.carRenderer.render(matrixStack, car, this.field_146999_f / 2, 55, 23);
    }

    public double getDamagePercent(EntityCarDamageBase car) {
        float dmg = car.getDamage();
        dmg = Math.min(dmg, 100.0f);
        return MathUtils.round(dmg, 2);
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.drawDamage(matrixStack);
    }

    public void drawDamage(MatrixStack matrixStack) {
        EntityCarBase car = this.tile.getCarOnTop();
        if (!(car instanceof EntityCarDamageBase)) {
            return;
        }
        EntityCarDamageBase c = (EntityCarDamageBase)car;
        double percent = 100.0 - this.getDamagePercent(c);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int scaled = (int)(72.0 * percent / 100.0);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i + 52, j + 81, 176, 0, scaled, 10);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

