/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.gui.ContainerGasStation;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class GuiGasStation
extends ScreenBase<ContainerGasStation> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_gas_station.png");
    private TileEntityGasStation gasStation;
    private PlayerInventory playerInventory;
    private static final int TITLE_COLOR = Color.WHITE.getRGB();
    private static final int FONT_COLOR = Color.DARK_GRAY.getRGB();
    protected Button buttonStart;
    protected Button buttonStop;

    public GuiGasStation(ContainerGasStation gasStation, PlayerInventory playerInventory, ITextComponent title) {
        super(GUI_TEXTURE, gasStation, playerInventory, title);
        this.gasStation = gasStation.getGasStation();
        this.playerInventory = playerInventory;
        this.field_146999_f = 176;
        this.field_147000_g = 217;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.buttonStart = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 20, this.field_147009_r + 100, 40, 20, (ITextComponent)new TranslationTextComponent("button.car.start"), button -> {
            this.gasStation.setFueling(true);
            this.gasStation.sendStartFuelPacket(true);
        }));
        this.buttonStop = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.field_146999_f - 40 - 7, this.field_147009_r + 100, 40, 20, (ITextComponent)new TranslationTextComponent("button.car.stop"), button -> {
            this.gasStation.setFueling(false);
            this.gasStation.sendStartFuelPacket(false);
        }));
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.buttonStart.field_230693_o_ = !this.gasStation.isFueling();
        this.buttonStop.field_230693_o_ = this.gasStation.isFueling();
        this.func_238471_a_(matrixStack, this.field_230712_o_, new TranslationTextComponent("gui.gas_station").getString(), this.field_230708_k_ / 2, this.field_147009_r + 5, TITLE_COLOR);
        IFluidHandler fluidHandler = this.gasStation.getFluidHandlerInFront();
        if (fluidHandler instanceof Entity) {
            this.drawCarName(matrixStack, (Entity)fluidHandler);
        }
        this.drawCarFuel(matrixStack, fluidHandler);
        this.drawRefueled(matrixStack);
        this.drawBuffer(matrixStack);
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)this.playerInventory.func_145748_c_(), (float)(this.field_147003_i + 8), (float)(this.field_147009_r + this.field_147000_g - 93), FONT_COLOR);
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        ItemStack stack = this.gasStation.getTradingInventory().func_70301_a(0);
        if (stack.func_190926_b()) {
            return;
        }
        if (mouseX >= this.field_147003_i + 18 && mouseX <= this.field_147003_i + 33 && mouseY >= this.field_147009_r + 99 && mouseY <= this.field_147009_r + 114) {
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            list.add(new TranslationTextComponent("tooltip.trade", new Object[]{stack.func_190916_E(), stack.func_200301_q(), this.gasStation.getTradeAmount()}));
            this.func_238654_b_(matrixStack, list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    private void drawCarName(MatrixStack matrixStack, Entity entity) {
        String name = entity instanceof EntityGenericCar ? ((EntityGenericCar)entity).getShortName().getString() : entity.func_145748_c_().getString();
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)new TranslationTextComponent("gas_station.car_info", new Object[]{new StringTextComponent(name).func_240699_a_(TextFormatting.WHITE)}), (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 20), FONT_COLOR);
    }

    private void drawCarFuel(MatrixStack matrixStack, IFluidHandler handler) {
        if (handler == null) {
            this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)new TranslationTextComponent("gas_station.no_car"), (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 30), FONT_COLOR);
            return;
        }
        if (handler.getTanks() <= 0) {
            this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)new TranslationTextComponent("gas_station.fuel_empty"), (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 30), FONT_COLOR);
            return;
        }
        FluidStack tank = handler.getFluidInTank(0);
        TranslationTextComponent fuelText = new TranslationTextComponent("gas_station.car_fuel_amount", new Object[]{new StringTextComponent(String.valueOf(tank.getAmount())).func_240699_a_(TextFormatting.WHITE), new StringTextComponent(String.valueOf(handler.getTankCapacity(0))).func_240699_a_(TextFormatting.WHITE)});
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)fuelText, (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 30), FONT_COLOR);
        if (tank.isEmpty()) {
            return;
        }
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)new TranslationTextComponent("gas_station.car_fuel_type", new Object[]{new StringTextComponent(tank.getDisplayName().getString()).func_240699_a_(TextFormatting.WHITE)}), (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 40), FONT_COLOR);
    }

    private void drawRefueled(MatrixStack matrixStack) {
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)new TranslationTextComponent("gas_station.refueled", new Object[]{new StringTextComponent(String.valueOf(this.gasStation.getFuelCounter())).func_240699_a_(TextFormatting.WHITE)}), (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 60), FONT_COLOR);
    }

    private void drawBuffer(MatrixStack matrixStack) {
        FluidStack stack = this.gasStation.getStorage();
        if (stack.isEmpty()) {
            this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)new TranslationTextComponent("gas_station.fuel_empty"), (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 70), FONT_COLOR);
            return;
        }
        int amount = this.gasStation.getFuelAmount();
        TranslationTextComponent amountText = new TranslationTextComponent("gas_station.fuel_buffer_amount", new Object[]{new StringTextComponent(String.valueOf(amount)).func_240699_a_(TextFormatting.WHITE), new StringTextComponent(String.valueOf(this.gasStation.maxStorageAmount)).func_240699_a_(TextFormatting.WHITE)});
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)amountText, (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 70), FONT_COLOR);
        TranslationTextComponent bufferText = new TranslationTextComponent("gas_station.fuel_buffer_type", new Object[]{new StringTextComponent(stack.getDisplayName().getString()).func_240699_a_(TextFormatting.WHITE)});
        this.field_230712_o_.func_238422_b_(matrixStack, (ITextProperties)bufferText, (float)(this.field_147003_i + 63), (float)(this.field_147009_r + 80), FONT_COLOR);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

