/*
 * Decompiled with CFR 0.152.
 */
package com.ironkiller224.CavesAndTunnels.world.gen;

import com.ironkiller224.CavesAndTunnels.world.gen.generators.WorldGenStructure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.IWorldGenerator;
import scala.Console;

public class WorldGenCustomStructures
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            this.generateUnderGroundStructure(new WorldGenStructure("lostblacksmith"), world, random, chunkX, chunkZ, 90, 40, 5, false);
            this.generateUnderGroundStructure(new WorldGenStructure("minerheaven"), world, random, chunkX, chunkZ, 70, 30, 5, false);
            this.generateUnderGroundStructure(new WorldGenStructure("maze"), world, random, chunkX, chunkZ, 80, 3, 2, false);
            this.generateUnderGroundStructure(new WorldGenStructure("dungeon2"), world, random, chunkX, chunkZ, 80, 35, 5, true);
            this.generateUnderGroundStructure(new WorldGenStructure("dungeon3"), world, random, chunkX, chunkZ, 80, 35, 5, true);
            this.generateUnderGroundStructure(new WorldGenStructure("dungeon4"), world, random, chunkX, chunkZ, 80, 35, 5, true);
            this.generateUnderGroundStructure(new WorldGenStructure("vault1"), world, random, chunkX, chunkZ, 75, 45, 5, true);
            this.generateUnderGroundStructure(new WorldGenStructure("tomb1"), world, random, chunkX, chunkZ, 90, 45, 20, false);
            this.generateUnderGroundStructure(new WorldGenStructure("mushroomcavern"), world, random, chunkX, chunkZ, 120, 35, 20, false);
            this.generateUnderGroundStructure(new WorldGenStructure("netherdungeon"), world, random, chunkX, chunkZ, 150, 35, 20, false);
        } else if (world.field_73011_w.func_186058_p() == DimensionType.NETHER) {
            this.generateUnderGroundStructure(new WorldGenStructure("nethertower"), world, random, chunkX, chunkZ, 100, 32, 31, true);
        }
    }

    public void generateStructureOnSurface(WorldGenStructure generator, World world, Random random, int chunkX, int chunkZ, int chance, int yOffSet, Block topBlock, Biome b) {
        int x = chunkX * 16 + random.nextInt(15);
        int z = chunkZ * 16 + random.nextInt(15);
        int y = WorldGenCustomStructures.getGroundFromAbove(world, x, z, topBlock) + yOffSet;
        BlockPos pos = new BlockPos(x, y, z);
        Biome biome = world.field_73011_w.getBiomeForCoords(pos);
        if (world.func_175624_G() != WorldType.field_77138_c && b == biome && random.nextInt(chance) == 0 && y > 4) {
            generator.func_180709_b(world, random, pos);
        }
    }

    public void generateUnderGroundStructure(WorldGenStructure generator, World world, Random random, int chunkX, int chunkZ, int chance, int maxY, int minY, boolean lootChests) {
        int tempx = chunkX * 16 + random.nextInt(15);
        int tempz = chunkZ * 16 + random.nextInt(15);
        int tempy = random.nextInt(maxY - minY) + minY;
        BlockPos pos = new BlockPos(tempx, tempy, tempz);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && random.nextInt(chance) == 0 && !biome.equals(Biomes.field_150575_M.getClass())) {
            generator.func_180709_b(world, random, pos);
            if (lootChests) {
                int count = 0;
                for (int x = pos.func_177958_n(); x <= pos.func_177958_n() + 20; ++x) {
                    for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 30; ++y) {
                        for (int z = pos.func_177952_p(); z <= pos.func_177952_p() + 20; ++z) {
                            BlockPos tmp = new BlockPos(x, y, z);
                            if (!(world.func_175625_s(tmp) instanceof TileEntityChest)) continue;
                            TileEntityChest chest = (TileEntityChest)world.func_175625_s(tmp);
                            Console.out().println("chest" + ++count + " found");
                            if (count == 1) {
                                chest.func_189404_a(LootTableList.field_186421_c, random.nextLong());
                                continue;
                            }
                            chest.func_189404_a(LootTableList.field_186426_h, random.nextLong());
                        }
                    }
                }
            }
        }
    }

    public static int getGroundFromAbove(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }
}

